/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLDocumentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterFactory;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;

public class OWLModelWriter {
    private OWLModel model;
    private TripleStore tripleStore;
    private XMLWriter xmlWriter;

    public OWLModelWriter(OWLModel oWLModel, TripleStore tripleStore, Writer writer) {
        this.model = oWLModel;
        this.tripleStore = tripleStore;
        NamespaceManager namespaceManager = tripleStore.getNamespaceManager();
        String string = namespaceManager.getDefaultNamespace();
        if (string == null) {
            string = tripleStore.getName() + "#";
        }
        XMLWriterNamespaceManager xMLWriterNamespaceManager = Util.getNamespacePrefixes(namespaceManager, string);
        String string2 = Util.getOntologyName(oWLModel, tripleStore);
        this.xmlWriter = XMLWriterFactory.getInstance().createXMLWriter(writer, xMLWriterNamespaceManager, string2);
    }

    public OWLModelWriter(OWLModel oWLModel, TripleStore tripleStore, XMLWriter xMLWriter) {
        this.model = oWLModel;
        this.tripleStore = tripleStore;
        this.xmlWriter = xMLWriter;
    }

    public XMLWriter getXmlWriter() {
        return this.xmlWriter;
    }

    public void write() throws IOException {
        RDFXMLDocumentWriter rDFXMLDocumentWriter = new RDFXMLDocumentWriter(this.xmlWriter, Collections.singleton(this.getContentWriter(this.model, this.tripleStore)));
        rDFXMLDocumentWriter.writeDocument();
    }

    protected RDFXMLContentWriter getContentWriter(OWLModel oWLModel, TripleStore tripleStore) {
        return new OWLModelContentWriter(oWLModel, tripleStore);
    }
}

