/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLModelContentWriter
implements RDFXMLContentWriter {
    private OWLModel model;
    private TripleStore tripleStore;
    private Comparator<RDFResource> comparator;

    public OWLModelContentWriter(OWLModel oWLModel, TripleStore tripleStore) {
        this(oWLModel, tripleStore, null);
    }

    public OWLModelContentWriter(OWLModel oWLModel, TripleStore tripleStore, Comparator<RDFResource> comparator) {
        this.model = oWLModel;
        this.tripleStore = tripleStore;
        this.comparator = comparator;
    }

    protected Collection<RDFResource> getResources() {
        AbstractSet abstractSet = this.comparator != null ? new TreeSet<RDFResource>(this.comparator) : new HashSet();
        Iterator<RDFResource> iterator = this.tripleStore.listHomeResources();
        while (iterator.hasNext()) {
            RDFResource rDFResource = iterator.next();
            if (Util.isExcludedResource(rDFResource)) continue;
            abstractSet.add(rDFResource);
        }
        for (RDFResource rDFResource : this.model.getRDFProperties()) {
            Iterator<RDFResource> iterator2 = this.tripleStore.listSubjects((RDFProperty)rDFResource);
            while (iterator2.hasNext()) {
                RDFResource rDFResource2;
                RDFResource rDFResource3 = iterator2.next();
                if (!(rDFResource3 instanceof RDFResource) || Util.isExcludedResource(rDFResource2 = rDFResource3) || abstractSet.contains(rDFResource2)) continue;
                abstractSet.add(rDFResource2);
            }
        }
        try {
            abstractSet.removeAll(this.model.getSystemFrames().getOwlOntologyPointerClass().getInstances());
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not remove unwanted frames from OWL export", exception);
        }
        return abstractSet;
    }

    @Override
    public void writeContent(XMLWriter xMLWriter) throws IOException {
        OWLModelVisitorAdapter oWLModelVisitorAdapter;
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (OWLOntology rDFResource : this.model.getOWLOntologies()) {
            if (!rDFResource.getName().equals(this.tripleStore.getName())) continue;
            oWLModelVisitorAdapter = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter, this.comparator != null);
            ((RDFResourceRenderer)oWLModelVisitorAdapter).write();
            hashSet.add(rDFResource);
        }
        for (OWLAllDifferent oWLAllDifferent : this.model.getOWLAllDifferents()) {
            if (!this.model.getTripleStoreModel().getHomeTripleStore(oWLAllDifferent).equals(this.tripleStore)) continue;
            oWLModelVisitorAdapter = new RDFResourceRenderer(oWLAllDifferent, this.tripleStore, xMLWriter, this.comparator != null);
            ((RDFResourceRenderer)oWLModelVisitorAdapter).write();
            hashSet.add(oWLAllDifferent);
        }
        for (RDFResource rDFResource : this.getResources()) {
            oWLModelVisitorAdapter = new RDFAxiomRenderer(rDFResource, this.tripleStore, xMLWriter, this.comparator != null);
            ((RDFAxiomRenderer)oWLModelVisitorAdapter).write();
            hashSet.add(rDFResource);
        }
    }
}

