/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelOrderedWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;

public class OWLModelAllTripleStoresWriter {
    private OWLModel model;
    private URI uri;
    private boolean ordered;

    public OWLModelAllTripleStoresWriter(OWLModel oWLModel, URI uRI, boolean bl) {
        this.model = oWLModel;
        this.uri = uRI;
        this.ordered = bl;
    }

    public void write() throws Exception {
        Object object;
        Iterator<TripleStore> iterator = this.model.getTripleStoreModel().listUserTripleStores();
        TripleStore tripleStore = iterator.next();
        File file = new File(this.uri);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        String string = FileUtilities.getWriteEncoding();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        OWLModelWriter oWLModelWriter = this.getOwlModelWriter(tripleStore, bufferedWriter);
        oWLModelWriter.getXmlWriter().setEncoding(string);
        oWLModelWriter.write();
        bufferedWriter.flush();
        bufferedWriter.close();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string2 = object.getName();
            URI uRI = new URI(string2);
            Repository repository = this.model.getRepositoryManager().getRepository(uRI);
            if (repository == null || !repository.isWritable(uRI) || !repository.hasOutputStream(uRI)) continue;
            Log.getLogger().info("Saving import " + uRI + " to " + repository.getOntologyLocationDescription(uRI));
            OutputStream outputStream = repository.getOutputStream(uRI);
            OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter(outputStream, FileUtilities.getWriteEncoding());
            bufferedWriter = new BufferedWriter(outputStreamWriter2);
            OWLModelWriter oWLModelWriter2 = this.getOwlModelWriter((TripleStore)object, bufferedWriter);
            oWLModelWriter2.getXmlWriter().setEncoding(FileUtilities.getWriteEncoding());
            oWLModelWriter2.write();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        object = new RepositoryFileManager(this.model);
        ((RepositoryFileManager)object).saveGlobalRepositories();
        ((RepositoryFileManager)object).saveProjectRepositories(this.uri);
        Log.getLogger().info("... saving successful.");
    }

    private OWLModelWriter getOwlModelWriter(TripleStore tripleStore, Writer writer) {
        if (this.ordered) {
            return new OWLModelOrderedWriter(this.model, tripleStore, writer);
        }
        return new OWLModelWriter(this.model, tripleStore, writer);
    }
}

