/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.util.job;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;

public class GetTripleStoreOfTripleJob
extends ProtegeJob {
    private static final long serialVersionUID = -406814600433675121L;
    private RDFResource subject;
    private Slot slot;
    private Object object;

    public GetTripleStoreOfTripleJob(RDFResource rDFResource, Slot slot, Object object) {
        super((KnowledgeBase)rDFResource.getOWLModel());
        this.subject = rDFResource;
        this.slot = slot;
        this.object = object;
    }

    public OWLModel getKnowledgeBase() {
        return (OWLModel)super.getKnowledgeBase();
    }

    public String run() throws ProtegeException {
        TripleStore tripleStore = this.getTripleStore();
        if (tripleStore != null) {
            return tripleStore.getName();
        }
        return null;
    }

    private TripleStore getTripleStore() {
        if (this.object instanceof RDFSLiteral) {
            this.object = ((DefaultRDFSLiteral)this.object).getRawValue();
        }
        OWLModel oWLModel = this.subject.getOWLModel();
        for (TripleStore tripleStore : oWLModel.getTripleStoreModel().getTripleStores()) {
            if (!tripleStore.getNarrowFrameStore().getValues((Frame)this.subject, this.slot, null, false).contains(this.object)) continue;
            return tripleStore;
        }
        return null;
    }

    public TripleStore execute() throws ProtegeException {
        if (!this.getKnowledgeBase().getProject().isMultiUserClient()) {
            return this.getTripleStore();
        }
        String string = (String)super.execute();
        for (TripleStore tripleStore : this.getKnowledgeBase().getTripleStoreModel().getTripleStores()) {
            if (!tripleStore.getName().equals(string)) continue;
            return tripleStore;
        }
        return null;
    }

    public void localize(KnowledgeBase knowledgeBase) {
        super.localize(knowledgeBase);
        LocalizeUtils.localize((Object)this.subject, (KnowledgeBase)knowledgeBase);
        LocalizeUtils.localize((Object)this.slot, (KnowledgeBase)knowledgeBase);
        LocalizeUtils.localize((Object)this.object, (KnowledgeBase)knowledgeBase);
    }
}

