/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.util;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.util.ExpressionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionInfoUtils {
    public static List<ExpressionInfo<OWLRestriction>> getDirectContainingRestrictions(OWLNamedClass oWLNamedClass) {
        ArrayList<ExpressionInfo<OWLRestriction>> arrayList = new ArrayList<ExpressionInfo<OWLRestriction>>();
        for (RDFSClass rDFSClass : oWLNamedClass.getSuperclasses(false)) {
            Object object;
            if (rDFSClass instanceof OWLRestriction) {
                object = new ExpressionInfo<OWLRestriction>((OWLRestriction)rDFSClass, (OWLAnonymousClass)rDFSClass, oWLNamedClass);
                arrayList.add((ExpressionInfo<OWLRestriction>)object);
                continue;
            }
            if (!(rDFSClass instanceof OWLIntersectionClass)) continue;
            object = (OWLIntersectionClass)rDFSClass;
            for (RDFSClass rDFSClass2 : object.getOperands()) {
                if (!(rDFSClass2 instanceof OWLRestriction)) continue;
                ExpressionInfo<OWLRestriction> expressionInfo = new ExpressionInfo<OWLRestriction>((OWLRestriction)rDFSClass2, (OWLAnonymousClass)object, oWLNamedClass);
                arrayList.add(expressionInfo);
            }
        }
        Collections.sort(arrayList, new Comparator<ExpressionInfo<OWLRestriction>>(){

            @Override
            public int compare(ExpressionInfo<OWLRestriction> expressionInfo, ExpressionInfo<OWLRestriction> expressionInfo2) {
                RDFSClass rDFSClass = expressionInfo.getExpression().getProtegeType();
                RDFSClass rDFSClass2 = expressionInfo2.getExpression().getProtegeType();
                return rDFSClass.getName().compareTo(rDFSClass2.getName());
            }
        });
        return arrayList;
    }
}

