/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.awt.BorderLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimePanel
extends JPanel {
    private Listener listener;
    private JTextField hoursField;
    private JTextField minutesField;
    private JTextField secondsField;

    public TimePanel(Listener listener) {
        this.listener = listener;
        this.hoursField = new JTextField(2);
        this.minutesField = new JTextField(2);
        this.secondsField = new JTextField(2);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                TimePanel.this.notifyListener();
            }
        };
        this.hoursField.addFocusListener(focusListener);
        this.minutesField.addFocusListener(focusListener);
        this.secondsField.addFocusListener(focusListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.hoursField);
        jPanel.add(new JLabel(":"));
        jPanel.add(this.minutesField);
        jPanel.add(new JLabel(":"));
        jPanel.add(this.secondsField);
        this.setLayout(new BorderLayout());
        this.add("West", jPanel);
        this.add("Center", Box.createHorizontalGlue());
    }

    public void clear() {
        this.hoursField.setText("");
        this.minutesField.setText("");
        this.secondsField.setText("");
    }

    private int getInt(JTextField jTextField, int n) {
        String string = jTextField.getText();
        return this.getInt(string, n);
    }

    private int getInt(String string, int n) {
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= 0 && n2 < n) {
                return n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private String getString(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    public String getTime() {
        int n = this.getHours();
        int n2 = this.getMinutes();
        int n3 = this.getSeconds();
        return XMLSchemaDatatypes.getTimeString(n, n2, n3);
    }

    public int getHours() {
        return this.getInt(this.hoursField, 24);
    }

    public int getMinutes() {
        return this.getInt(this.minutesField, 60);
    }

    public int getSeconds() {
        return this.getInt(this.secondsField, 60);
    }

    public boolean isNull() {
        return this.hoursField.getText().length() + this.minutesField.getText().length() + this.secondsField.getText().length() == 0;
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.timeChanged(this);
        }
    }

    public void setTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.setTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
    }

    public void setTime(String string) {
        String[] stringArray = string.split(":");
        int n = stringArray.length > 0 ? this.getInt(stringArray[0], 24) : 0;
        int n2 = stringArray.length > 1 ? this.getInt(stringArray[1], 60) : 0;
        int n3 = stringArray.length > 2 ? this.getInt(stringArray[2], 60) : 0;
        this.setTime(n, n2, n3);
    }

    public void setTime(int n, int n2, int n3) {
        this.hoursField.setText("" + this.getString(n));
        this.minutesField.setText("" + this.getString(n2));
        this.secondsField.setText("" + this.getString(n3));
    }

    public void setEnabled(boolean bl) {
        this.hoursField.setEnabled(bl);
        this.minutesField.setEnabled(bl);
        this.secondsField.setEnabled(bl);
        super.setEnabled(bl);
    }

    public static interface Listener {
        public void timeChanged(TimePanel var1);
    }
}

