/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OWLFormWidget
extends FormWidget {
    public static final String DISABLED_BY_USER = "DisabledByUser";

    protected Cls getCustomizedParent(Cls cls) {
        return this.getCustomizedParent(cls, new HashSet());
    }

    protected Cls getCustomizedParent(Cls cls, Set set) {
        set.add(cls);
        Project project = cls.getProject();
        Cls cls2 = null;
        Iterator iterator = cls.getDirectSuperclasses().iterator();
        while (iterator.hasNext() && cls2 == null) {
            Cls cls3 = (Cls)iterator.next();
            if (cls3 instanceof OWLAnonymousClass || set.contains(cls3)) continue;
            if (project.hasCustomizedDescriptor(cls3)) {
                cls2 = cls3;
                break;
            }
            cls2 = this.getCustomizedParent(cls3, set);
            break;
        }
        return cls2;
    }

    protected Collection getClsSlots() {
        Cls cls = this.getCls();
        if (cls instanceof RDFSNamedClass) {
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)cls;
            OWLModel oWLModel = rDFSNamedClass.getOWLModel();
            Set<Slot> set = new HashSet();
            try {
                set = rDFSNamedClass.getAssociatedProperties();
            }
            catch (Exception exception) {
                Log.getLogger().warning("Problem at getting class form slots for " + cls);
            }
            set = new HashSet(oWLModel.getVisibleResources(set.iterator()));
            for (String string : this.getPropertyList().getNames()) {
                Slot slot;
                if (string == null || (slot = this.getKnowledgeBase().getSlot(string)) == null) continue;
                set.add(slot);
            }
            return set;
        }
        return super.getClsSlots();
    }

    protected boolean isSuitable(WidgetDescriptor widgetDescriptor, Cls cls, Slot slot) {
        String string;
        if (slot instanceof RDFProperty && cls instanceof RDFSNamedClass && (string = widgetDescriptor.getWidgetClassName()) != null && OWLWidgetMapper.isIncompatibleWidgetName(string)) {
            return false;
        }
        return super.isSuitable(widgetDescriptor, cls, slot);
    }

    protected void onTemplateSlotAdded(Cls cls, Slot slot) {
        WidgetMapper widgetMapper = cls.getProject().getWidgetMapper();
        String string = widgetMapper.getDefaultWidgetClassName(cls, slot, null);
        if (string == null) {
            return;
        }
        super.onTemplateSlotAdded(cls, slot);
    }

    protected void onTemplateFacetValueChanged(Cls cls, Slot slot, Facet facet) {
        if (this.hasWidgetDescriptor(slot)) {
            super.onTemplateFacetValueChanged(cls, slot, facet);
        }
    }

    protected void onTemplateSlotRemoved(Cls cls, Slot slot) {
        if (this.hasWidgetDescriptor(slot)) {
            super.onTemplateSlotRemoved(cls, slot);
        }
    }

    public void reload() {
        if (!OWLNames.Cls.ONTOLOGY.equals(this.getCls().getName())) {
            super.reload();
        }
    }

    public void replaceSelectedWidget(String string) {
        Collection collection = this.getSelection();
        super.replaceSelectedWidget(string);
        if (collection.size() == 1) {
            AbstractSlotWidget abstractSlotWidget = (AbstractSlotWidget)collection.iterator().next();
            abstractSlotWidget.getDescriptor().getPropertyList().setBoolean(DISABLED_BY_USER, string == null);
        }
    }
}

