/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JDateChooser;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.ReadOnlyWidgetConfigurationPanel;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class OWLDateWidget
extends AbstractPropertyWidget {
    private JDateChooser dateChooser;
    private LabeledComponent lc;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("date".equals(propertyChangeEvent.getPropertyName())) {
                OWLDateWidget.this.updateValues();
            }
        }
    };
    private final Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDateWidget.this.deleteValue();
        }
    };
    private final Action setAction = new AbstractAction("Set value", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLDateWidget.this.setPropertyValue(new Date());
        }
    };
    private boolean ignoreUpdate = false;

    public OWLDateWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    protected RDFSLiteral createPropertyValue(Date date) {
        String string = XMLSchemaDatatypes.getDateString(date);
        RDFSDatatype rDFSDatatype = this.getOWLModel().getRDFSDatatypeByURI(XSDDatatype.XSDdate.getURI());
        return this.getOWLModel().createRDFSLiteral(string, rDFSDatatype);
    }

    protected void deleteValue() {
        this.getEditedResource().setPropertyValue(this.getRDFProperty(), null);
    }

    protected Component getCenterComponent() {
        return this.dateChooser;
    }

    protected Date getDate() {
        return this.dateChooser.getDate();
    }

    public static Date getDate(String string) {
        String[] stringArray;
        int n;
        if (string == null) {
            return null;
        }
        Date date = new Date();
        int n2 = string.indexOf("T");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf("Z")) >= 0) {
            string = string.substring(0, n);
        }
        if ((stringArray = string.split("-")).length >= 3) {
            try {
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]) - 1;
                int n5 = Integer.parseInt(stringArray[2]);
                date = new Date(new GregorianCalendar(n3, n4, n5).getTimeInMillis());
            }
            catch (Exception exception) {
                Log.getLogger().warning("Could not parse value " + string + ": " + exception.getMessage());
            }
        }
        return date;
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.dateChooser = new JDateChooser();
        this.lc = new LabeledComponent(this.getRDFProperty().getBrowserText(), this.getCenterComponent());
        this.lc.addHeaderButton(this.setAction);
        this.lc.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)this.lc);
        this.enabledCompListeners();
    }

    private void setDateChooserValue() {
        RDFProperty rDFProperty;
        RDFResource rDFResource = this.getEditedResource();
        Object object = rDFResource.getPropertyValue(rDFProperty = this.getRDFProperty());
        this.setValue(object == null ? null : object.toString());
    }

    protected void setValue(String string) {
        this.disableCompListeners();
        Date date = OWLDateWidget.getDate(string);
        this.dateChooser.setDate(date);
        this.enabledCompListeners();
    }

    private void setPropertyValue(Date date) {
        RDFResource rDFResource = this.getEditedResource();
        RDFProperty rDFProperty = this.getRDFProperty();
        if (rDFResource != null && rDFProperty != null) {
            if (date == null) {
                rDFResource.setPropertyValue(rDFProperty, null);
            } else {
                RDFSLiteral rDFSLiteral = this.createPropertyValue(date);
                rDFResource.setPropertyValue(rDFProperty, rDFSLiteral);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(!this.isReadOnlyConfiguredWidget() && bl);
        this.updateComponents();
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.disableCompListeners();
        if (instance != null) {
            this.setDateChooserValue();
        }
        this.updateComponents();
        this.enabledCompListeners();
    }

    public void setValues(Collection collection) {
        super.setValues(collection);
        this.updateComponents();
        this.ignoreUpdate = true;
        this.setDateChooserValue();
        this.ignoreUpdate = false;
    }

    protected void updateComponents() {
        boolean bl = !this.isReadOnlyConfiguredWidget();
        RDFResource rDFResource = this.getEditedResource();
        RDFProperty rDFProperty = this.getRDFProperty();
        if (rDFResource != null && rDFProperty != null && rDFResource.isEditable()) {
            boolean bl2 = rDFResource.getPropertyValue(rDFProperty) != null;
            this.setAction.setEnabled(bl && !bl2);
            this.deleteAction.setEnabled(bl && bl2);
            this.enableDateChooser(bl && bl2);
            this.lc.revalidate();
        } else {
            this.setAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.enableDateChooser(false);
        }
    }

    private void enableDateChooser(boolean bl) {
        for (Component component : this.dateChooser.getComponents()) {
            component.setEnabled(bl);
        }
    }

    protected void updateValues() {
        if (!this.ignoreUpdate) {
            Date date = this.getDate();
            this.setPropertyValue(date);
        }
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        WidgetConfigurationPanel widgetConfigurationPanel = super.createWidgetConfigurationPanel();
        widgetConfigurationPanel.addTab("Options", (Component)new ReadOnlyWidgetConfigurationPanel((AbstractSlotWidget)this));
        return widgetConfigurationPanel;
    }

    protected void enabledCompListeners() {
        this.dateChooser.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void disableCompListeners() {
        this.dateChooser.removePropertyChangeListener(this.propertyChangeListener);
    }

    @Deprecated
    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(OWLDateWidget.class, cls, slot);
    }
}

