/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class ModalProgressBarDialog
extends JDialog
implements Runnable {
    private JProgressBar progressBar;
    private LabeledComponent labeledComponent;

    public ModalProgressBarDialog(int n, int n2, Frame frame, String string) {
        super(frame);
        this.setTitle(string);
        this.progressBar = new JProgressBar(n, n2);
        this.progressBar.setIndeterminate(false);
        this.init();
    }

    private void init() {
        this.progressBar.setValue(0);
        this.setModal(true);
        this.setSize(200, 100);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        this.labeledComponent = new LabeledComponent("-------------------------------------------", (Component)this.progressBar);
        jComponent.add("Center", (Component)this.labeledComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ComponentUtilities.center((Component)this);
    }

    public void run() {
        this.show();
    }

    public void setLabel(String string) {
        this.labeledComponent.setHeaderLabel(string);
    }

    public boolean setValue(int n) {
        if (n != this.progressBar.getValue()) {
            this.progressBar.setValue(n);
            JComponent jComponent = (JComponent)this.getContentPane();
            Dimension dimension = jComponent.getSize();
            jComponent.paintImmediately(new Rectangle(0, 0, dimension.width, dimension.height));
            return true;
        }
        return false;
    }

    public boolean setValueRelative(double d) {
        int n = (int)((double)(this.progressBar.getMaximum() - this.progressBar.getMinimum()) * d);
        return this.setValue(n);
    }
}

