/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class TripleStoreSelectionPanel
extends JPanel {
    private OWLModel owlModel;
    private JTable table;
    private TripleStoreTableModel tableModel;
    private static final String HELP_TEXT = "<p>If the main ontology imports other ontologies, this panel indicates whether or not the various imports are editable. If an imported ontology is editable then it can be set to be the 'Active Ontology', which is the ontology that any edits are applied to.</p><p>Whether or not an imported ontology is editable depends on where the ontology was imported from.  For example, ontologies that are imported from the local file system will probably be editable, where as ontologies that are imported from the web will not be editable.</p>";

    public TripleStoreSelectionPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.tableModel = new TripleStoreTableModel(oWLModel);
        this.table = new JTable(this.tableModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout(0, 16));
        LabeledComponent labeledComponent = new LabeledComponent("Ontologies", jScrollPane);
        this.add("Center", (Component)labeledComponent);
        this.setPreferredSize(new Dimension(700, Math.min(700, this.tableModel.getRowCount() * this.table.getRowHeight() + 240)));
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.setColumnWidth(1, 50);
        this.setColumnWidth(2, 400);
        this.setColumnWidth(0, 50);
        JComponent jComponent = OWLUI.createHelpPanel(HELP_TEXT, "What is the Active Ontology?");
        this.add("South", jComponent);
    }

    private void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public static void showDialog(OWLModel oWLModel) {
        TripleStoreSelectionPanel tripleStoreSelectionPanel = new TripleStoreSelectionPanel(oWLModel);
        ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), tripleStoreSelectionPanel, "Active Ontology", 14);
    }
}

