/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.DropDownOverlayIcon;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreSelectionPanel;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TripleStoreSelectionAction
extends AbstractAction {
    private JButton button;
    private JLabel label;
    private OWLModel owlModel;

    public TripleStoreSelectionAction(OWLModel oWLModel) {
        super("Select active sub-ontology...", OWLIcons.getImageIcon("SelectActiveTripleStore"));
        this.owlModel = oWLModel;
        this.label = new JLabel("                       ");
        this.updateLabel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TripleStoreSelectionPanel.showDialog(this.owlModel);
        this.updateLabel();
    }

    public void activateButton(JButton jButton) {
        this.button = jButton;
        jButton.setToolTipText((String)this.getValue("Name"));
        jButton.setRolloverIcon(new DropDownOverlayIcon(jButton.getIcon(), jButton));
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && TripleStoreSelectionAction.this.isEnabled()) {
                    TripleStoreSelectionAction.this.handleRightClick();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && TripleStoreSelectionAction.this.isEnabled()) {
                    TripleStoreSelectionAction.this.handleRightClick();
                }
            }
        });
    }

    private void handleRightClick() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        TripleStoreTableModel tripleStoreTableModel = new TripleStoreTableModel(this.owlModel);
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        TripleStore tripleStore2 = tripleStoreModel.getTopTripleStore();
        Object object = new DropDownAction("<Main File>", tripleStore2);
        Serializable serializable = new JCheckBoxMenuItem((Action)object);
        ((AbstractButton)serializable).setSelected(tripleStore2 == tripleStore);
        jPopupMenu.add((JMenuItem)serializable);
        for (int i = 1; i < tripleStoreTableModel.getRowCount(); ++i) {
            object = tripleStoreTableModel.getTripleStore(i);
            try {
                serializable = new URI(object.getName());
                Repository repository = this.owlModel.getRepositoryManager().getRepository((URI)serializable);
                if (repository == null || !repository.isWritable((URI)serializable)) continue;
                DropDownAction dropDownAction = new DropDownAction(((URI)serializable).toString(), (TripleStore)object);
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(dropDownAction);
                jCheckBoxMenuItem.setToolTipText(object.getName());
                jCheckBoxMenuItem.setSelected(object == tripleStore);
                jPopupMenu.add(jCheckBoxMenuItem);
                continue;
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
        jPopupMenu.show(this.button, 0, this.button.getHeight());
    }

    public Component getLabelPanel() {
        return this.label;
    }

    private void updateLabel() {
        TripleStore tripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        OWLOntology oWLOntology = tripleStore.getOWLOntology();
        if (oWLOntology != null) {
            String string = oWLOntology.getURI();
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            this.label.setText(string);
        } else {
            this.label.setText("");
        }
    }

    private class DropDownAction
    extends AbstractAction {
        private TripleStore tripleStore;

        public DropDownAction(String string, TripleStore tripleStore) {
            super(string);
            this.tripleStore = tripleStore;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TripleStoreUtil.switchTripleStore(TripleStoreSelectionAction.this.owlModel, this.tripleStore);
            TripleStoreSelectionAction.this.updateLabel();
        }
    }
}

