/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.tooltips;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLToolTipGenerator;
import java.net.URI;

public class HomeOntologyToolTipGenerator
implements OWLToolTipGenerator {
    public String getToolTipText(RDFSClass rDFSClass) {
        return this.getToolTipText((RDFResource)rDFSClass);
    }

    public String getToolTipText(RDFProperty rDFProperty) {
        return this.getToolTipText((RDFResource)rDFProperty);
    }

    public String getToolTipText(RDFResource rDFResource) {
        String string = null;
        if (rDFResource != null) {
            OWLModel oWLModel;
            TripleStore tripleStore;
            string = "";
            if (!(rDFResource instanceof OWLAnonymousClass)) {
                string = string + "<b>" + rDFResource.getURI() + "</b>";
            }
            if ((tripleStore = (oWLModel = rDFResource.getOWLModel()).getTripleStoreModel().getHomeTripleStore(rDFResource)) != null) {
                OWLOntology oWLOntology = tripleStore.getOWLOntology();
                try {
                    URI uRI = new URI(oWLOntology.getURI());
                    string = string + "<br><b>ontology:</b> " + uRI;
                    RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
                    Repository repository = repositoryManager.getRepository(uRI);
                    String string2 = "";
                    if (repository != null) {
                        string2 = repository.getOntologyLocationDescription(uRI);
                    } else {
                        String string3 = oWLModel.getProject().getName();
                        if (string3 == null) {
                            string3 = "not yet saved";
                        }
                        string2 = "main ontology [" + string3 + "]";
                    }
                    string = string + "<br><b>location:</b> " + string2;
                }
                catch (Exception exception) {
                    Log.emptyCatchBlock((Throwable)exception);
                }
            }
            string = !string.equals("") ? "<html><body>" + string + "</body></html>" : null;
        }
        return string;
    }
}

