/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModelColumns;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class OWLTestResultsTableModel
extends AbstractTableModel
implements Disposable,
OWLTestResultsTableModelColumns {
    private List items;
    private OWLModel owlModel;
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)rDFSClass);
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)rDFProperty);
        }

        public void individualDeleted(RDFResource rDFResource) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)rDFResource);
        }
    };

    public OWLTestResultsTableModel(OWLModel oWLModel, Collection collection) {
        this.items = new ArrayList(collection);
        this.owlModel = oWLModel;
        oWLModel.addModelListener(this.listener);
    }

    private void deleteItemsWith(Frame frame) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            OWLTestResult oWLTestResult = this.getOWLTestResult(i);
            if (!frame.equals(oWLTestResult.getHost())) continue;
            this.items.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return RDFResource.class;
        }
        if (n == 2) {
            return String.class;
        }
        if (n == 0) {
            return Icon.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int n) {
        if (n == 1) {
            return "Source";
        }
        if (n == 2) {
            return "Test Result";
        }
        if (n == 0) {
            return "Type";
        }
        return null;
    }

    RDFResource getSource(int n) {
        return this.getOWLTestResult(n).getHost();
    }

    public OWLTestResult getOWLTestResult(int n) {
        return (OWLTestResult)this.items.get(n);
    }

    public int getRowCount() {
        return this.items.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 2) {
            return this.getOWLTestResult(n).getMessage();
        }
        if (n2 == 1) {
            return this.getSource(n);
        }
        if (n2 == 0) {
            return this.getOWLTestResult(n).getIcon();
        }
        return null;
    }

    public void removeRow(int n) {
        this.items.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public String saveToFile(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (OWLTestResult oWLTestResult : this.items) {
                printWriter.println(oWLTestResult.toString());
            }
            printWriter.close();
            return null;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public void setItems(Collection collection) {
        this.items = new ArrayList(collection);
        this.fireTableDataChanged();
    }
}

