/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.testing.AbstractOWLTestAction;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OWLTestInstanceAction
extends AbstractOWLTestAction {
    private Selectable selectable;

    public OWLTestInstanceAction(OWLModel oWLModel, OWLTestManager oWLTestManager, Selectable selectable) {
        super(oWLModel, oWLTestManager, "Run ontology tests on this resource", OWLIcons.getImageIcon("TestInstance"));
        this.selectable = selectable;
        selectable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLTestInstanceAction.this.updateStatus();
            }
        });
    }

    protected OWLTestResultsPanel getTestResultsPanel(OWLModel oWLModel, List list) {
        Instance instance = (Instance)this.selectable.getSelection().iterator().next();
        return new OWLTestResultsPanel(oWLModel, list, instance, true);
    }

    protected List run(OWLTest[] oWLTestArray, Task task) {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.selectable.getSelection()) {
            if (!(e instanceof RDFResource)) continue;
            RDFResource rDFResource = (RDFResource)e;
            for (int i = 0; i < oWLTestArray.length; ++i) {
                OWLTest oWLTest = oWLTestArray[i];
                if (oWLTest instanceof RDFSClassTest && rDFResource instanceof RDFSClass) {
                    arrayList.addAll(((RDFSClassTest)oWLTest).test((RDFSClass)rDFResource));
                }
                if (oWLTest instanceof RDFPropertyTest && rDFResource instanceof OWLProperty) {
                    arrayList.addAll(((RDFPropertyTest)oWLTest).test((OWLProperty)rDFResource));
                }
                if (!(oWLTest instanceof RDFResourceTest)) continue;
                arrayList.addAll(((RDFResourceTest)oWLTest).test(rDFResource));
            }
        }
        return arrayList;
    }

    private void updateStatus() {
        Collection collection = this.selectable.getSelection();
        this.setEnabled(collection.size() > 0);
    }
}

