/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.FrameWithBrowserText;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class TooltippedSelectableTree
extends SelectableTree {
    private static final long serialVersionUID = 6697428920472428637L;

    public TooltippedSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        super(action, lazyTreeRoot);
        final int n = ToolTipManager.sharedInstance().getDismissDelay();
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n);
            }
        });
        this.setToolTipText("");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath;
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0 && (treePath = this.getPathForRow(n)) != null) {
            Object object = treePath.getLastPathComponent();
            RDFResource rDFResource = null;
            if (object instanceof LazyTreeNode) {
                Frame frame;
                LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
                Object object2 = lazyTreeNode.getUserObject();
                if (object2 instanceof RDFResource) {
                    rDFResource = (RDFResource)object2;
                } else if (object2 instanceof FrameWithBrowserText && (frame = ((FrameWithBrowserText)object2).getFrame()) instanceof RDFResource) {
                    rDFResource = (RDFResource)frame;
                }
            }
            if (rDFResource != null) {
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
                return OWLUI.getOWLToolTipText(rDFResource);
            }
        }
        return null;
    }
}

