/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreePanel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;

public abstract class EditableSubsumptionTreePanel
extends SubsumptionTreePanel {
    public EditableSubsumptionTreePanel(Cls cls, Slot slot, Slot slot2) {
        super(cls, slot, slot2, false);
        Action action;
        Action action2 = this.createCreateAction();
        if (action2 != null) {
            this.getLabeledComponent().addHeaderButton(action2);
        }
        if ((action = this.createDeleteAction()) != null) {
            this.getLabeledComponent().addHeaderButton(action);
        }
    }

    protected Action createCreateAction() {
        AllowableAction allowableAction = new AllowableAction("Create subclass", null, Icons.getCreateIcon(), this){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = this.getSelection();
                if (!collection.isEmpty()) {
                    RDFSNamedClass rDFSNamedClass = EditableSubsumptionTreePanel.this.getOWLModel().createSubclass(null, collection);
                    EditableSubsumptionTreePanel.this.extendSelection(rDFSNamedClass);
                }
            }

            public void onSelectionChange() {
                super.onSelectionChange();
                this.setAllowed(!this.getSelection().isEmpty());
            }
        };
        allowableAction.setEnabled(false);
        return allowableAction;
    }

    protected Action createDeleteAction() {
        DeleteInstancesAction deleteInstancesAction = new DeleteInstancesAction(this){

            public void onAboutToDelete() {
                EditableSubsumptionTreePanel.this.removeSelection();
            }

            public void onSelectionChange() {
                boolean bl = false;
                Frame frame = (Frame)CollectionUtilities.getFirstItem((Collection)this.getSelection());
                if (frame != null) {
                    bl = frame.isEditable();
                }
                this.setAllowed(bl);
            }
        };
        deleteInstancesAction.setEnabled(false);
        return deleteInstancesAction;
    }
}

