/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class ChangedClassesPanel
extends ResultsPanel {
    private Action assertAction = new AbstractAction("Assert selected change(s)", OWLIcons.getAssertChangeIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            ChangedClassesPanel.this.assertSelectedChanges();
        }
    };
    private static Map panels = new HashMap();
    private Action showAction = new AbstractAction("Show selected class in hierarchies", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            ChangedClassesPanel.this.showSelectedCls();
        }
    };
    private Action saveAction = new AbstractAction("Save classification results", OWLIcons.getSaveInferredIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            ChangedClassesPanel.this.saveClassificationResults();
        }
    };
    private JButton sortJButton;
    private boolean sortedByClass = true;
    public static final String SORT_BY_CLASS = "Sort Classification Results by Class";
    public static final String SORT_BY_CHANGE = "Sort Classification Results by Change Type";
    private Action sortAction = new AbstractAction("Sort Classification Results by Change Type", OWLIcons.getDisplayChangedClassesIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            ChangedClassesPanel.this.sortClassificationResults();
        }
    };
    private ChangedClassesTableModel tableModel;
    private JTable table;
    public static final String TAB_NAME = "Classification Results";

    public ChangedClassesPanel(OWLModel oWLModel) {
        super(oWLModel);
        this.tableModel = new ChangedClassesTableModel(oWLModel);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ChangedClassesPanel.this.showSelectedCls();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChangedClassesPanel.this.updateActions();
            }
        });
        this.table.setDefaultRenderer(Frame.class, (TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(250);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        this.addButton(this.assertAction);
        this.sortJButton = this.addButton(this.sortAction);
        this.addButton(this.saveAction);
        this.updateActions();
        this.setCenterComponent(jScrollPane);
    }

    private void assertSelectedChanges() {
        int[] nArray = this.table.getSelectedRows();
        this.tableModel.assertChanges(nArray);
    }

    public boolean contains(Cls cls) {
        return this.tableModel.contains(cls);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    public static void dispose(OWLModel oWLModel) {
        ChangedClassesPanel changedClassesPanel = (ChangedClassesPanel)panels.get(oWLModel);
        if (changedClassesPanel != null) {
            panels.remove(oWLModel);
            changedClassesPanel.dispose();
        }
    }

    public static ChangedClassesPanel get(OWLModel oWLModel) {
        ChangedClassesPanel changedClassesPanel = (ChangedClassesPanel)panels.get(oWLModel);
        if (changedClassesPanel == null) {
            changedClassesPanel = new ChangedClassesPanel(oWLModel);
            panels.put(oWLModel, changedClassesPanel);
        }
        return changedClassesPanel;
    }

    public int getChangeCount() {
        return this.tableModel.getRowCount();
    }

    public String getChangeText(Cls cls) {
        return this.tableModel.getChangeText(cls);
    }

    public Icon getIcon() {
        return OWLIcons.getImageIcon("ChangedClasses");
    }

    public String getTabName() {
        return TAB_NAME;
    }

    ChangedClassesTableModel getTableModel() {
        return this.tableModel;
    }

    public void refresh() {
        this.tableModel.refill();
    }

    private void showSelectedCls() {
        Cls cls;
        int n = this.table.getSelectedRow();
        if (n >= 0 && (cls = this.tableModel.getCls(n)) instanceof RDFSClass) {
            this.showHostResource((RDFSClass)cls);
        }
    }

    private void updateActions() {
        int[] nArray = this.table.getSelectedRows();
        this.showAction.setEnabled(nArray.length == 1);
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Cls cls = this.tableModel.getCls(n);
                if (OWLUtil.isInconsistent(cls) || !cls.isEditable()) continue;
                this.assertAction.setEnabled(true);
                return;
            }
        }
        this.assertAction.setEnabled(false);
        this.saveAction.setEnabled(true);
    }

    private void saveClassificationResults() {
        JFileChooser jFileChooser = ComponentFactory.createFileChooser((String)"Save classfication results", (String)"Property Files", (String)"");
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (this.savePropertyFile(file)) {
                ModalDialog.showMessageDialog((Component)this, (String)("Classification results written out successfully to:\n" + file.getAbsolutePath()), (String)"Classification results saved");
            } else {
                ModalDialog.showMessageDialog((Component)this, (String)"Error writing the classification results", (String)"Error");
            }
        }
    }

    public boolean savePropertyFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.getClassificationResults().store(fileOutputStream, "Generated by Protege OWL. Export of classification results.");
            return true;
        }
        catch (Exception exception) {
            Log.getLogger().warning("Could not write property file: " + file.getAbsolutePath());
            return false;
        }
    }

    public Properties getClassificationResults() {
        Properties properties = new Properties();
        for (int i = 0; i < this.getTableModel().getRowCount(); ++i) {
            try {
                Cls cls = (Cls)this.getTableModel().getValueAt(i, 0);
                String string = (String)this.getTableModel().getValueAt(i, 1);
                properties.put(cls.getBrowserText(), string);
                continue;
            }
            catch (Exception exception) {
                Log.getLogger().warning("Error at writing classification result from row " + i);
            }
        }
        return properties;
    }

    public void sortClassificationResults() {
        this.sortedByClass = !this.sortedByClass;
        this.tableModel.refill(this.sortedByClass);
        this.sortJButton.setToolTipText(this.sortedByClass ? SORT_BY_CHANGE : SORT_BY_CLASS);
    }
}

