/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChangedClassItem
implements Comparable<ChangedClassItem> {
    private OWLNamedClass cls;
    private Collection<RDFSClass> addedSuperClses = new ArrayList<RDFSClass>();
    private Collection<RDFSClass> removedSuperClses = new ArrayList<RDFSClass>();

    ChangedClassItem(OWLNamedClass oWLNamedClass) {
        this.cls = oWLNamedClass;
    }

    void addAddedSuperCls(Cls cls) {
        this.addedSuperClses.add((RDFSClass)cls);
    }

    void addRemovedSuperCls(Cls cls) {
        this.removedSuperClses.add((RDFSClass)cls);
    }

    void assertChange() {
        for (RDFSClass rDFSClass : this.addedSuperClses) {
            this.cls.addSuperclass(rDFSClass);
        }
        for (RDFSClass rDFSClass : this.removedSuperClses) {
            this.cls.removeSuperclass(rDFSClass);
        }
        OWLUtil.setConsistentClassificationStatus(this.cls);
    }

    @Override
    public int compareTo(ChangedClassItem changedClassItem) {
        return this.cls.compareTo(changedClassItem.cls);
    }

    OWLNamedClass getCls() {
        return this.cls;
    }

    void removeAddedSuperCls(Cls cls) {
        this.removedSuperClses.add((RDFSClass)cls);
    }

    public String toString() {
        if (this.cls.getClassificationStatus() == 2) {
            return "Inconsistent";
        }
        if (this.addedSuperClses.size() == 1 && this.removedSuperClses.size() == 1) {
            Cls cls = this.removedSuperClses.iterator().next();
            Cls cls2 = this.addedSuperClses.iterator().next();
            return "Moved from " + cls.getBrowserText() + " to " + cls2.getBrowserText();
        }
        if (this.addedSuperClses.size() > 0 && this.removedSuperClses.size() > 0) {
            return this.toString("Moved from", this.removedSuperClses.iterator()) + this.toString(" to", this.addedSuperClses.iterator());
        }
        if (this.addedSuperClses.size() > 0) {
            Iterator<RDFSClass> iterator = this.addedSuperClses.iterator();
            return this.toString("Added", iterator);
        }
        Iterator<RDFSClass> iterator = this.removedSuperClses.iterator();
        return this.toString("Removed", iterator);
    }

    private String toString(String string, Iterator iterator) {
        int n = 0;
        String string2 = "";
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            string2 = string2 + cls.getBrowserText();
            if (iterator.hasNext()) {
                string2 = string2 + ", ";
            }
            ++n;
        }
        return string + " " + string2;
    }
}

