/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.util.ExclusiveRunnable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.search.finder.BasicFind;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadedFind
extends BasicFind {
    private static Logger log = Log.getLogger(ThreadedFind.class);
    private Thread searchThread;
    private DoFind currentfind = new DoFind();

    public ThreadedFind(OWLModel oWLModel, int n) {
        super(oWLModel, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSearch(String string, int n) {
        ThreadedFind threadedFind = this;
        synchronized (threadedFind) {
            this.currentfind.setString(string);
            this.currentfind.setType(n);
            this.searchThread = new Thread((Runnable)((Object)this.currentfind));
            this.searchThread.start();
        }
    }

    private void startSuperSearch(String string, int n) {
        super.startSearch(string, n);
    }

    public void cancelSearch() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Cancelling search [" + Thread.currentThread().getName() + "]");
        }
        super.cancelSearch();
        if (this.currentfind != null) {
            this.currentfind.abort();
        }
    }

    class DoFind
    extends ExclusiveRunnable {
        private String string;
        private int searchType;

        DoFind() {
        }

        public void setString(String string) {
            this.string = string;
        }

        public void setType(int n) {
            this.searchType = n;
        }

        public void execute() {
            ThreadedFind.this.startSuperSearch(this.string, this.searchType);
        }
    }
}

