/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.RetainFindResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindResultsPanel
extends JComponent {
    private static Logger log = Log.getLogger(FindResultsPanel.class);
    private static final String SEARCH_PATTERN_LABEL = "Search Pattern";
    private static final String SAVE_RESULTS_LABEL = "Save Results";
    private Find find;
    private JButton saveResultButton;
    private JComboBox searchTypeCombo;
    private JTextField textField;
    private JButton searchButton;
    private JPanel mainPanel;
    private AbstractFindResultsView view;
    private Action saveResultsAction = new AbstractAction("Save Results", Icons.getDownIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            FindResultsPanel.this.view.requestDispose();
            FindResultsPanel.this.setSaveResultsEnabled(false);
            RetainFindResultsPanel retainFindResultsPanel = new RetainFindResultsPanel(FindResultsPanel.this.find.getModel(), FindResultsPanel.this);
            ResultsPanelManager.addResultsPanel(FindResultsPanel.this.find.getModel(), retainFindResultsPanel, true);
        }
    };

    public FindResultsPanel(Find find, AbstractFindResultsView abstractFindResultsView) {
        this.setLayout(new BorderLayout());
        this.find = find;
        this.view = abstractFindResultsView;
        this.textField = this.createTextField();
        find.addResultListener(new SearchAdapter(){

            public void searchCancelledEvent(Find find) {
                if (FindResultsPanel.this.textField != null) {
                    FindResultsPanel.this.textField.setEnabled(true);
                }
            }

            public void searchCompleteEvent(int n, Find find) {
                if (FindResultsPanel.this.textField != null) {
                    FindResultsPanel.this.textField.setEnabled(true);
                }
            }
        });
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindResultsPanel.this.refresh();
            }
        });
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindResultsPanel.this.refresh();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                FindResultsPanel.this.requestFocus();
            }
        });
        abstractFindResultsView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FindResultsPanel.this.selectResource();
                }
            }
        });
        this.searchTypeCombo = this.createTypeCombo();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(SEARCH_PATTERN_LABEL));
        jPanel.add(this.searchTypeCombo);
        jPanel.add(this.textField);
        jPanel.add(this.searchButton);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)abstractFindResultsView, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    public void setSaveResultsEnabled(boolean bl) {
        if (bl) {
            if (this.saveResultButton == null) {
                this.saveResultButton = new JButton(this.saveResultsAction);
                this.mainPanel.add((Component)this.saveResultButton, "South");
            }
        } else if (this.saveResultButton != null) {
            this.mainPanel.remove(this.saveResultButton);
            this.saveResultButton = null;
        }
    }

    public void refresh() {
        this.refresh(this.find.getSearchType());
    }

    public void refresh(int n) {
        this.textField.setEnabled(false);
        String string = this.textField.getText();
        if (!this.find.getLastSearch().equals(string) || this.find.getSearchType() != n) {
            this.find.startSearch(string, n);
        } else {
            this.textField.setEnabled(true);
        }
    }

    public void selectResource() {
        this.view.selectResource();
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    private JTextField createTextField() {
        JTextField jTextField = new JTextField();
        FontMetrics fontMetrics = this.getFontMetrics(jTextField.getFont());
        int n = fontMetrics.getHeight() + fontMetrics.getDescent();
        jTextField.setPreferredSize(new Dimension(120, n));
        jTextField.setText(this.find.getLastSearch());
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 40: {
                        FindResultsPanel.this.view.requestFocus();
                    }
                }
            }
        });
        return jTextField;
    }

    private JComboBox createTypeCombo() {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                object = Find.searchTypeString[(Integer)object];
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        jComboBox.addItem(new Integer(1));
        jComboBox.addItem(new Integer(0));
        jComboBox.addItem(new Integer(2));
        jComboBox.addItem(new Integer(3));
        jComboBox.setSelectedItem(new Integer(this.find.getSearchType()));
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = (Integer)itemEvent.getItem();
                int n2 = FindResultsPanel.this.find.getSearchType();
                if (n2 != n) {
                    FindResultsPanel.this.refresh(n);
                }
            }
        });
        return jComboBox;
    }
}

