/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.Collection;
import java.util.Iterator;

public class FindResult {
    public static final int RESOURCE_NAME = 0;
    public static final int PROPERTY_NAME = 1;
    public static final int MATCH_VALUE = 2;
    public static final int LANG = 3;
    public static final int NUM_COLUMNS = 4;
    private RDFResource res;
    private Slot prop;
    private String matchValue;
    private String lang;
    private String searchTerm;

    public static FindResult createFindResult(RDFResource rDFResource, Slot slot, String string) {
        try {
            return new FindResult(rDFResource, slot, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private FindResult(RDFResource rDFResource, Slot slot, String string) throws Exception {
        this.res = rDFResource;
        this.prop = slot;
        this.searchTerm = string;
        if (slot instanceof RDFProperty) {
            Collection collection = rDFResource.getPropertyValues((RDFProperty)slot);
            Iterator iterator = collection.iterator();
            while (this.matchValue == null && iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof RDFSLiteral) {
                    RDFSLiteral rDFSLiteral = (RDFSLiteral)e;
                    if (this.matches(rDFSLiteral.getString(), string)) {
                        this.matchValue = rDFSLiteral.getString();
                        this.lang = rDFSLiteral.getLanguage();
                        continue;
                    }
                    throw new Exception("Cannot find search term [" + string + "] in literal [" + rDFSLiteral + "]");
                }
                if (this.matches((String)e, string)) {
                    this.matchValue = (String)e;
                    continue;
                }
                throw new Exception("Cannot find search term [" + string + "] in string [" + e + "]");
            }
        } else {
            this.matchValue = (String)rDFResource.getOwnSlotValue(slot);
        }
    }

    public Object get(int n) {
        switch (n) {
            case 0: {
                return this.res;
            }
            case 1: {
                return this.prop;
            }
            case 2: {
                return this.render(this.matchValue);
            }
            case 3: {
                return this.lang;
            }
        }
        return null;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public RDFResource getMatchingResource() {
        return this.res;
    }

    private String render(String string) {
        try {
            String string2 = this.searchTerm.replaceAll("\\*", "");
            String string3 = string2.toLowerCase();
            String string4 = string.toLowerCase();
            int n = string4.indexOf(string3);
            int n2 = n + string3.length();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer = stringBuffer.insert(n2, "</b>");
            stringBuffer = stringBuffer.insert(n, "<b>");
            string = "<html>" + stringBuffer.toString() + "</html>";
        }
        catch (Exception exception) {
            string = "<html><font color=RED>" + string + "</font></html>";
        }
        return string;
    }

    public RDFResource getHost() {
        return (RDFResource)this.get(0);
    }

    public static String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Resource";
            }
            case 1: {
                return "Matching Property";
            }
            case 2: {
                return "Match Value";
            }
            case 3: {
                return "Language";
            }
        }
        return "Unnamed";
    }

    private boolean matches(String string, String string2) {
        String string3 = string2.replaceAll("\\*", "");
        String string4 = string3.toLowerCase();
        String string5 = string.toLowerCase();
        return string5.indexOf(string4) >= 0;
    }

    public String toString() {
        return "Result [" + this.res + ", " + this.prop + ", " + this.matchValue + ", " + this.lang + "]";
    }
}

