/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFind
implements Find {
    private static Logger log = Log.getLogger(BasicFind.class);
    private Find.FindStatus status = Find.FindStatus.INIT;
    private static final int MAX_MATCHES = -1;
    OWLModel owlModel;
    private Map<RDFResource, FindResult> results = new HashMap<RDFResource, FindResult>();
    private String searchString;
    private int searchType;
    private List<SearchListener> listeners;

    public BasicFind(OWLModel oWLModel, int n) {
        this.owlModel = oWLModel;
        this.searchType = n;
    }

    @Override
    public void startSearch(String string) {
        this.startSearch(string, this.searchType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSearch(String string, int n) {
        block38: {
            Object object;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting search on " + string + " with type " + n + " [" + Thread.currentThread().getName() + "]");
            }
            try {
                Object object2;
                Slot slot;
                Object object3;
                object = this;
                synchronized (object) {
                    switch (this.status) {
                        case INIT: 
                        case COMPLETED: 
                        case CANCELLED: {
                            this.searchString = string;
                            this.searchType = n;
                            this.results.clear();
                            this.status = Find.FindStatus.RUNNING;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Should not start new search before existing search completes");
                        }
                    }
                }
                this.notifySearchStarted();
                if (string == null || string.length() <= 0) break block38;
                object = this.getSearchProperties();
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    object3 = (Slot)object4.next();
                    if (this.status == Find.FindStatus.CANCELLING) break;
                    slot = this.searchOnSlot((Slot)object3, string, null, n);
                    object2 = this;
                    synchronized (object2) {
                        this.results.putAll((Map<RDFResource, FindResult>)slot);
                    }
                    this.notifyResultsUpdated();
                }
                if ((object4 = this.owlModel.getDefaultLanguage()) == null) break block38;
                object3 = object.iterator();
                while (object3.hasNext()) {
                    slot = (Slot)object3.next();
                    if (this.status == Find.FindStatus.CANCELLING) {
                        break;
                    }
                    if (slot.equals(this.owlModel.getNameSlot())) continue;
                    object2 = this.searchOnSlot(slot, string, (String)object4, n);
                    BasicFind basicFind = this;
                    synchronized (basicFind) {
                        this.results.putAll((Map<RDFResource, FindResult>)object2);
                    }
                    this.notifyResultsUpdated();
                }
            }
            finally {
                object = this;
                synchronized (object) {
                    switch (this.status) {
                        case RUNNING: {
                            this.status = Find.FindStatus.COMPLETED;
                            break;
                        }
                        case CANCELLING: {
                            this.status = Find.FindStatus.CANCELLED;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Programmer error");
                        }
                    }
                    this.notifyAll();
                }
            }
        }
        switch (this.status) {
            case COMPLETED: {
                this.notifySearchComplete();
                break;
            }
            case CANCELLED: {
                this.notifySearchCancelled();
                break;
            }
            default: {
                throw new RuntimeException("Programmer error");
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished search on " + string + " with type " + n + " [" + Thread.currentThread().getName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSearch() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            switch (this.status) {
                case RUNNING: {
                    this.status = Find.FindStatus.CANCELLING;
                    break;
                }
            }
        }
    }

    protected Map<RDFResource, FindResult> searchOnSlot(Slot slot, String string, String string2, int n) {
        Object object;
        Frame frame;
        Object object2;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting search on slot = " + slot + " [" + Thread.currentThread().getName() + "]");
        }
        HashMap<RDFResource, FindResult> hashMap = new HashMap<RDFResource, FindResult>();
        Slot slot2 = this.owlModel.getNameSlot();
        Object object3 = null;
        String string3 = string;
        switch (n) {
            case 0: {
                string3 = string3 + "*";
            }
            case 3: {
                if (slot.equals(slot2) || string2 == null) break;
                string3 = "~#" + string2 + " " + string3;
                break;
            }
            case 1: {
                string3 = string3 + "*";
            }
            case 2: {
                string3 = "*" + string3;
            }
        }
        if ((n == 0 || n == 3) && slot.equals(slot2)) {
            string3 = "*" + string3;
        }
        object3 = this.owlModel.getMatchingFrames(slot, null, false, string3, -1);
        if ((n == 0 || n == 3) && slot.equals(slot2)) {
            object2 = new HashSet();
            frame = object3.iterator();
            while (frame.hasNext()) {
                object = (Frame)frame.next();
                if (n == 0 && object instanceof RDFResource && ((RDFResource)object).getLocalName().startsWith(string)) {
                    object2.add(object);
                    continue;
                }
                if (n != 3 || !(object instanceof RDFResource) || !((RDFResource)object).getLocalName().equals(string)) continue;
                object2.add(object);
            }
            object3 = object2;
        }
        if (object3 != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                FindResult findResult;
                frame = (Frame)object2.next();
                if (this.status == Find.FindStatus.CANCELLING) break;
                if (!this.isValidFrameToSearch(frame) || (findResult = FindResult.createFindResult((RDFResource)(object = (RDFResource)frame), slot, string)) == null) continue;
                hashMap.put((RDFResource)object, findResult);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished searching on slot " + slot + " [" + Thread.currentThread().getName() + "]");
        }
        return hashMap;
    }

    protected List<Slot> getSearchProperties() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        Collection collection = this.owlModel.getSearchSynonymProperties();
        arrayList.addAll(collection);
        arrayList.add(this.owlModel.getNameSlot());
        Slot slot = this.owlModel.getOWLNamedClassClass().getBrowserSlotPattern().getFirstSlot();
        if (!slot.equals(this.owlModel.getNameSlot()) && !collection.contains(slot)) {
            arrayList.add(slot);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RDFResource, FindResult> getResults() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return new HashMap<RDFResource, FindResult>(this.results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RDFResource> getResultResources() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return new HashSet<RDFResource>(this.results.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultCount() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return this.results.size();
        }
    }

    @Override
    public String getSummaryText() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            switch (this.status) {
                case RUNNING: 
                case CANCELLING: {
                    return "Searching for \"" + this.searchString + "\" : (" + this.results.size() + " matches)";
                }
                case COMPLETED: 
                case CANCELLED: {
                    return "Results for \"" + this.searchString + "\" : (" + this.results.size() + " matches)";
                }
                case INIT: {
                    return "Search Starting...";
                }
            }
            throw new RuntimeException("Programmer error: unknown state");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastSearch() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return this.searchString;
        }
    }

    @Override
    public String getDescription() {
        return "Find Resource";
    }

    @Override
    public OWLModel getModel() {
        return this.owlModel;
    }

    @Override
    public int getNumSearchProperties() {
        return this.getSearchProperties().size();
    }

    protected boolean isValidFrameToSearch(Frame frame) {
        Class<?> clazz = frame.getClass();
        return RDFResource.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSearchType() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return this.searchType;
        }
    }

    protected void notifySearchStarted() {
        for (SearchListener searchListener : this.getListeners()) {
            searchListener.searchStartedEvent(this);
            searchListener.searchEvent(this);
        }
    }

    protected void notifyResultsUpdated() {
        for (SearchListener searchListener : this.getListeners()) {
            searchListener.resultsUpdatedEvent(this.results.size(), this);
            searchListener.searchEvent(this);
        }
    }

    protected void notifySearchComplete() {
        for (SearchListener searchListener : this.getListeners()) {
            searchListener.searchCompleteEvent(this.results.size(), this);
            searchListener.searchEvent(this);
        }
    }

    protected void notifySearchCancelled() {
        for (SearchListener searchListener : this.getListeners()) {
            searchListener.searchCancelledEvent(this);
            searchListener.searchEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResultListener(SearchListener searchListener) {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SearchListener>();
            }
            this.listeners.add(searchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeResultListener(SearchListener searchListener) {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            if (this.listeners != null) {
                return this.listeners.remove(searchListener);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SearchListener> getListeners() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return new ArrayList<SearchListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Find.FindStatus getFindStatus() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForSearchComplete() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            block8: while (true) {
                switch (this.status) {
                    case RUNNING: 
                    case CANCELLING: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            log.log(Level.SEVERE, "Unexpeccted interrupt", interruptedException);
                        }
                        continue block8;
                    }
                }
                break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        BasicFind basicFind = this;
        synchronized (basicFind) {
            switch (this.status) {
                case INIT: 
                case COMPLETED: 
                case CANCELLED: {
                    this.searchString = "";
                    this.results.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException("Attempted reset while still running");
                }
            }
        }
    }
}

