/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsListView;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsTableView;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResultsViewModelFind;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;

abstract class AbstractFindAction
extends AbstractAction
implements FindAction {
    private JTextComponent searchBox;
    protected ResultsViewModelFind findModel;
    protected boolean allowSave;
    private HostResourceDisplay hostResourceDisplay;

    public AbstractFindAction(ResultsViewModelFind resultsViewModelFind, Icon icon) {
        this(resultsViewModelFind, icon, null);
    }

    public AbstractFindAction(ResultsViewModelFind resultsViewModelFind, Icon icon, HostResourceDisplay hostResourceDisplay) {
        this(resultsViewModelFind, icon, hostResourceDisplay, false);
    }

    public AbstractFindAction(ResultsViewModelFind resultsViewModelFind, Icon icon, HostResourceDisplay hostResourceDisplay, boolean bl) {
        super(resultsViewModelFind.getFind().getDescription(), icon);
        this.findModel = resultsViewModelFind;
        this.hostResourceDisplay = hostResourceDisplay;
        this.allowSave = bl;
    }

    public void setTextBox(JTextComponent jTextComponent) {
        this.searchBox = jTextComponent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "";
        if (this.searchBox != null) {
            string = this.searchBox.getText();
        }
        this.findModel.getFind().startSearch(string);
        if (this.findModel.getFind().getNumSearchProperties() > 1) {
            this.showResults(new FindResultsTableView(this.findModel, this.hostResourceDisplay));
        } else {
            this.showResults(new FindResultsListView(this.findModel, this.hostResourceDisplay));
        }
    }

    protected abstract void showResults(AbstractFindResultsView var1);
}

