/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModelColumns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUsageTableModel
extends AbstractTableModel
implements Disposable,
FindUsageTableModelColumns {
    private static final long serialVersionUID = 6478475132021195153L;
    private List<FindUsageTableItem> items;
    private OWLModel owlModel;
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            FindUsageTableModel.this.deleteItemsWith((Frame)rDFSClass);
        }

        public void individualDeleted(RDFResource rDFResource) {
            FindUsageTableModel.this.deleteItemsWith((Frame)rDFResource);
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            FindUsageTableModel.this.deleteItemsWith((Frame)rDFProperty);
        }
    };
    private int sortColumn = 0;

    public FindUsageTableModel(OWLModel oWLModel, Collection<FindUsageTableItem> collection) {
        this.items = new ArrayList<FindUsageTableItem>(collection);
        this.owlModel = oWLModel;
        this.sort();
        oWLModel.addModelListener(this.listener);
    }

    private void deleteItemsWith(Frame frame) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            FindUsageTableItem findUsageTableItem = this.getItem(i);
            if (!findUsageTableItem.contains(frame)) continue;
            this.items.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return RDFResource.class;
        }
        if (n == 2) {
            return RDFResource.class;
        }
        if (n == 1) {
            return Icon.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (n == 0) {
            string = "Resource";
        } else if (n == 2) {
            string = "Expression";
        } else if (n == 1) {
            string = "Type";
        }
        if (string != null && n == this.sortColumn) {
            string = "[" + string + "]";
        }
        return string;
    }

    RDFResource getHost(int n) {
        return this.getItem((int)n).host;
    }

    private FindUsageTableItem getItem(int n) {
        return this.items.get(n);
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    public RDFResource getUsage(int n) {
        return (RDFResource)this.getValueAt(n, 2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 2) {
            return this.getItem((int)n).usage;
        }
        if (n2 == 0) {
            return this.getHost(n);
        }
        if (n2 == 1) {
            return this.getItem(n).getIcon();
        }
        return null;
    }

    public void setItems(Collection<FindUsageTableItem> collection) {
        this.items = new ArrayList<FindUsageTableItem>(collection);
        this.fireTableDataChanged();
    }

    public void setSortColumn(int n) {
        this.sortColumn = n;
        this.sort();
        this.fireTableStructureChanged();
    }

    private void sort() {
        Collections.sort(this.items, new Comparator<FindUsageTableItem>(){

            @Override
            public int compare(FindUsageTableItem findUsageTableItem, FindUsageTableItem findUsageTableItem2) {
                if (FindUsageTableModel.this.sortColumn == 0) {
                    return findUsageTableItem.host.getBrowserText().compareTo(findUsageTableItem2.host.getBrowserText());
                }
                if (FindUsageTableModel.this.sortColumn == 1) {
                    return new Integer(findUsageTableItem.type).compareTo(new Integer(findUsageTableItem2.type));
                }
                if (FindUsageTableModel.this.sortColumn == 2) {
                    return findUsageTableItem.usage.getBrowserText().compareTo(findUsageTableItem2.usage.getBrowserText());
                }
                return 0;
            }
        });
    }
}

