/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.restrictions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameComponent;
import edu.stanford.smi.protegex.owl.ui.restrictions.FillerTextArea;
import edu.stanford.smi.protegex.owl.ui.restrictions.RestrictionKindRenderer;
import edu.stanford.smi.protegex.owl.ui.search.ResourceListFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RestrictionEditorPanel
extends JComponent
implements ModalDialogFactory.CloseCallback {
    private Action createDatatypePropertyAction;
    private Action createObjectPropertyAction;
    private Action createRDFPropertyAction;
    private FillerTextArea fillerTextArea;
    private JList kindList;
    private OWLModel owlModel;
    private JList propertyList;
    private OWLSymbolPanel symbolPanel;
    private RDFSClass targetClass;
    private Action viewAction;
    private static String recentPropertyName;

    public RestrictionEditorPanel(OWLModel oWLModel, Cls cls, RDFProperty rDFProperty, String string, RDFSClass rDFSClass) {
        this.owlModel = oWLModel;
        this.targetClass = rDFSClass;
        this.createActions();
        this.propertyList = ComponentFactory.createList(null);
        this.propertyList.getSelectionModel().setSelectionMode(0);
        this.propertyList.setCellRenderer(FrameRenderer.createInstance());
        this.propertyList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RestrictionEditorPanel.this.changeProperty((RDFProperty)RestrictionEditorPanel.this.propertyList.getSelectedValue());
                RestrictionEditorPanel.this.enableActions();
            }
        });
        this.propertyList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && RestrictionEditorPanel.this.viewAction.isEnabled()) {
                    RestrictionEditorPanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        this.updatePropertiesList();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.propertyList);
        jScrollPane.setPreferredSize(new Dimension(240, 150));
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", (Component)((Object)new ResourceListFinder(this.propertyList, "Find")));
        Cls[] clsArray = ProfilesManager.getSupportedRestrictionMetaClses(oWLModel);
        this.kindList = new JList<Cls>(clsArray);
        this.kindList.setCellRenderer(new RestrictionKindRenderer());
        this.kindList.getSelectionModel().setSelectionMode(0);
        this.kindList.setSelectedValue(cls, true);
        JScrollPane jScrollPane2 = new JScrollPane(this.kindList);
        jScrollPane2.setPreferredSize(new Dimension(160, 150));
        this.kindList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RestrictionEditorPanel.this.changeKind((Cls)RestrictionEditorPanel.this.kindList.getSelectedValue());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", (Component)new LabeledComponent("Restriction", jScrollPane2));
        jPanel2.add("Center", new JPanel());
        this.symbolPanel = new OWLSymbolPanel(oWLModel, false);
        if (string == null) {
            this.symbolPanel.setErrorFlag(true);
        }
        this.enableSymbolPanel();
        this.fillerTextArea = new FillerTextArea(oWLModel, this.symbolPanel);
        this.fillerTextArea.setRestrictionProperty(this.getRestrictionProperty(cls));
        if (string != null) {
            this.fillerTextArea.setText(string);
        }
        this.symbolPanel.setSymbolEditor(this.fillerTextArea);
        JPanel jPanel3 = new JPanel(new BorderLayout(4, 4));
        this.fillerTextArea.setPreferredSize(new Dimension(200, 64));
        this.fillerTextArea.setLineWrap(true);
        this.fillerTextArea.setWrapStyleWord(true);
        jPanel3.add("North", new JScrollPane(this.fillerTextArea));
        jPanel3.add("Center", this.symbolPanel);
        this.setLayout(new BorderLayout(10, 10));
        LabeledComponent labeledComponent = new LabeledComponent("Restricted Property", (Component)jPanel);
        if (OWLUtil.hasRDFProfile(oWLModel)) {
            labeledComponent.addHeaderButton(this.createRDFPropertyAction);
        }
        labeledComponent.addHeaderButton(this.createDatatypePropertyAction);
        labeledComponent.addHeaderButton(this.createObjectPropertyAction);
        this.add("Center", (Component)labeledComponent);
        this.add("East", jPanel2);
        this.add("South", (Component)new LabeledComponent("Filler", (Component)jPanel3));
        if (rDFProperty != null) {
            this.propertyList.setSelectedValue(rDFProperty, true);
        } else if (this.propertyList.getModel().getSize() > 0) {
            this.propertyList.setSelectedIndex(0);
        }
    }

    private void addNewProperty(RDFProperty rDFProperty) {
        rDFProperty.setFunctional(false);
        rDFProperty.setDomainDefined(false);
        this.showModalPropertyWidget(rDFProperty);
        this.updatePropertiesList();
        this.propertyList.setSelectedValue(rDFProperty, true);
    }

    public boolean canClose(int n) {
        if (n == 1) {
            RDFProperty rDFProperty = (RDFProperty)this.propertyList.getSelectedValue();
            if (rDFProperty != null) {
                String string = this.fillerTextArea.getText();
                if (string.length() == 0) {
                    this.symbolPanel.displayError("Please enter a filler");
                    return false;
                }
                try {
                    this.fillerTextArea.checkExpression(string);
                    return true;
                }
                catch (Throwable throwable) {
                    this.symbolPanel.displayError(throwable);
                    return false;
                }
            }
            this.symbolPanel.displayError("Please select a property");
            return false;
        }
        return true;
    }

    private void changeKind(Cls cls) {
        this.fillerTextArea.setRestrictionProperty(this.getRestrictionProperty(cls));
        this.fillerTextArea.displayError();
        this.enableSymbolPanel();
    }

    private void changeProperty(RDFProperty rDFProperty) {
        this.fillerTextArea.setOnProperty(rDFProperty);
        this.fillerTextArea.displayError();
        this.enableSymbolPanel();
        this.fillerTextArea.requestFocus();
        if (rDFProperty != null) {
            recentPropertyName = rDFProperty.getName();
        }
    }

    private void createActions() {
        this.viewAction = new AbstractAction("View Property...", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                RDFProperty rDFProperty = (RDFProperty)RestrictionEditorPanel.this.propertyList.getSelectedValue();
                RestrictionEditorPanel.this.showModalPropertyWidget(rDFProperty);
            }
        };
        this.viewAction.setEnabled(false);
        this.createDatatypePropertyAction = new AbstractAction("Create datatype property...", OWLIcons.getCreatePropertyIcon("OWLDatatypeProperty")){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLDatatypeProperty oWLDatatypeProperty = RestrictionEditorPanel.this.owlModel.createOWLDatatypeProperty(null);
                RestrictionEditorPanel.this.addNewProperty(oWLDatatypeProperty);
            }
        };
        this.createObjectPropertyAction = new AbstractAction("Create object property...", OWLIcons.getCreatePropertyIcon("OWLObjectProperty")){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLObjectProperty oWLObjectProperty = RestrictionEditorPanel.this.owlModel.createOWLObjectProperty(null);
                RestrictionEditorPanel.this.addNewProperty(oWLObjectProperty);
            }
        };
        this.createRDFPropertyAction = new AbstractAction("Create RDF property...", OWLIcons.getCreatePropertyIcon("RDFProperty")){

            public void actionPerformed(ActionEvent actionEvent) {
                RDFProperty rDFProperty = RestrictionEditorPanel.this.owlModel.createRDFProperty(null);
                RestrictionEditorPanel.this.addNewProperty(rDFProperty);
            }
        };
    }

    private OWLRestriction createRestriction(Cls cls, RDFProperty rDFProperty, String string) throws Exception {
        Collection collection = CollectionUtilities.createCollection((Object)this.owlModel.getCls(OWLNames.Cls.ANONYMOUS_ROOT));
        OWLModel oWLModel = this.owlModel;
        OWLRestriction oWLRestriction = (OWLRestriction)oWLModel.createCls(null, collection, cls);
        oWLRestriction.setOnProperty(rDFProperty);
        oWLRestriction.setFillerText(string);
        return oWLRestriction;
    }

    private void enableSymbolPanel() {
        Cls cls = this.getSelectedMetaCls();
        this.symbolPanel.setEnabled(true);
        this.symbolPanel.enableActions(this.getSelectedProperty(), cls);
    }

    private void enableActions() {
        this.viewAction.setEnabled(true);
    }

    OWLRestriction getResult() {
        try {
            String string = this.fillerTextArea.getText();
            return this.createRestriction(this.getSelectedMetaCls(), this.getSelectedProperty(), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private RDFProperty getRestrictionProperty(Cls cls) {
        if (cls.getName().equals(OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION)) {
            return this.owlModel.getRDFProperty(OWLNames.Slot.ALL_VALUES_FROM);
        }
        if (cls.getName().equals(OWLNames.Cls.SOME_VALUES_FROM_RESTRICTION)) {
            return this.owlModel.getRDFProperty(OWLNames.Slot.SOME_VALUES_FROM);
        }
        if (cls.getName().equals(OWLNames.Cls.HAS_VALUE_RESTRICTION)) {
            return this.owlModel.getRDFProperty(OWLNames.Slot.HAS_VALUE);
        }
        if (cls.getName().equals(OWLNames.Cls.MAX_CARDINALITY_RESTRICTION)) {
            return this.owlModel.getRDFProperty(OWLNames.Slot.MAX_CARDINALITY);
        }
        if (cls.getName().equals(OWLNames.Cls.MIN_CARDINALITY_RESTRICTION)) {
            return this.owlModel.getRDFProperty(OWLNames.Slot.MIN_CARDINALITY);
        }
        return this.owlModel.getRDFProperty(OWLNames.Slot.CARDINALITY);
    }

    Cls getSelectedMetaCls() {
        return (Cls)this.kindList.getSelectedValue();
    }

    RDFProperty getSelectedProperty() {
        return (RDFProperty)this.propertyList.getSelectedValue();
    }

    public static OWLRestriction showCreateDialog(Component component, RDFSClass rDFSClass, Cls cls, RDFProperty rDFProperty) {
        return RestrictionEditorPanel.showCreateDialog(component, rDFSClass, cls, rDFProperty, null);
    }

    public static OWLRestriction showCreateDialog(Component component, RDFSClass rDFSClass, Cls cls, RDFProperty rDFProperty, String string) {
        Object object;
        OWLModel oWLModel = rDFSClass.getOWLModel();
        if (rDFProperty == null && recentPropertyName != null && (object = oWLModel.getRDFResource(recentPropertyName)) instanceof RDFProperty) {
            rDFProperty = (RDFProperty)object;
        }
        object = new RestrictionEditorPanel(oWLModel, cls, rDFProperty, string, rDFSClass);
        super.getFillerTextArea().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                    ProtegeUI.getModalDialogFactory().attemptDialogClose(1);
                }
            }
        });
        if (ProtegeUI.getModalDialogFactory().showDialog(component, (Component)object, "Create Restriction", 11, (ModalDialogFactory.CloseCallback)object) == 1) {
            return ((RestrictionEditorPanel)object).getResult();
        }
        return null;
    }

    private FillerTextArea getFillerTextArea() {
        return this.fillerTextArea;
    }

    public static OWLRestriction showCreateDialog(Component component, RDFSClass rDFSClass, Cls cls) {
        return RestrictionEditorPanel.showCreateDialog(component, rDFSClass, cls, null);
    }

    private void showModalPropertyWidget(RDFProperty rDFProperty) {
        ClsWidget clsWidget = this.owlModel.getProject().createRuntimeClsWidget((Instance)rDFProperty);
        InstanceNameComponent instanceNameComponent = new InstanceNameComponent();
        instanceNameComponent.setInstance(rDFProperty);
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.add((Component)instanceNameComponent, "North");
        jPanel.add((Component)((JComponent)clsWidget), "Center");
        ProtegeUI.getModalDialogFactory().showDialog(this, jPanel, "Property " + rDFProperty.getBrowserText(), 14);
    }

    private void updatePropertiesList() {
        Object object;
        Object object22;
        Collection collection = this.owlModel.getVisibleUserDefinedRDFProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : collection) {
            if (object22.isAnnotationProperty()) continue;
            arrayList.add(object22);
        }
        OWLNamedClass oWLNamedClass = this.owlModel.getSystemFrames().getDirectedBinaryRelationCls();
        if (this.targetClass != null && this.targetClass.hasSuperclass(oWLNamedClass)) {
            object22 = this.owlModel.getSystemFrames().getFromSlot();
            if (object22.isVisible()) {
                arrayList.add(object22);
            }
            if ((object = this.owlModel.getSystemFrames().getToSlot()).isVisible()) {
                arrayList.add(object);
            }
        }
        object22 = arrayList.toArray(new RDFProperty[0]);
        Arrays.sort(object22, new FrameComparator());
        object = Arrays.asList(object22);
        this.propertyList.setListData(object.toArray());
    }
}

