/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextField;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceFilterListModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ResourceSelectionComboBox
extends JComboBox
implements KeyListener {
    private Color oldBackground;
    private Component host;
    private ResourceSelectionListener listener;
    private ResourceFilterListModel model;

    public ResourceSelectionComboBox(Collection collection, ResourceSelectionListener resourceSelectionListener) {
        this(null, collection, resourceSelectionListener);
    }

    public ResourceSelectionComboBox(Component component, Collection collection, ResourceSelectionListener resourceSelectionListener) {
        this(component, collection, resourceSelectionListener, (ListCellRenderer)new FrameRenderer());
    }

    public ResourceSelectionComboBox(Component component, Collection collection, ResourceSelectionListener resourceSelectionListener, ListCellRenderer listCellRenderer) {
        this.host = component;
        this.listener = resourceSelectionListener;
        this.setRenderer(listCellRenderer);
        this.setBackground(Color.white);
        this.model = new ResourceFilterListModel(collection);
        this.setModel(this.model);
        if (this.host != null) {
            this.oldBackground = this.host.getBackground();
            this.host.setBackground(this.oldBackground.darker());
            this.updateBounds();
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    ResourceSelectionComboBox.this.host.setBackground(ResourceSelectionComboBox.this.oldBackground);
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                    ResourceSelectionComboBox.this.okay();
                }
            }
        });
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c;
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyCode() == 8) {
            this.setPopupVisible(false);
            this.model.backspace();
            this.updateBounds();
            this.showPopup();
        } else if (keyEvent.getKeyCode() == 10) {
            this.okay();
        }
        if (n != 8 && n != 27 && OWLTextField.isIdChar(c = keyEvent.getKeyChar())) {
            this.setPopupVisible(false);
            this.model.addChar(c);
            this.updateBounds();
            this.showPopup();
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.getParent().remove(this);
        this.setVisible(false);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void okay() {
        RDFResource rDFResource = (RDFResource)this.getSelectedItem();
        if (rDFResource != null) {
            this.listener.resourceSelected(rDFResource);
        }
        this.setPopupVisible(false);
    }

    public static void selectFrame(Collection collection, JComponent jComponent, int n, ResourceSelectionListener resourceSelectionListener) {
        ResourceSelectionComboBox.selectResource(collection, jComponent, n, resourceSelectionListener, (ListCellRenderer)new FrameRenderer());
    }

    public static void selectResource(Collection collection, JComponent jComponent, int n, ResourceSelectionListener resourceSelectionListener, ListCellRenderer listCellRenderer) {
        ResourceSelectionComboBox resourceSelectionComboBox = new ResourceSelectionComboBox(jComponent, collection, resourceSelectionListener, listCellRenderer);
        jComponent.removeAll();
        jComponent.add(resourceSelectionComboBox);
        resourceSelectionComboBox.setLocation(n, jComponent.getHeight());
        resourceSelectionComboBox.addKeyListener(resourceSelectionComboBox);
        resourceSelectionComboBox.showPopup();
        resourceSelectionComboBox.requestFocus();
    }

    private void updateBounds() {
        if (this.host != null) {
            int n = this.getPreferredSize().width + 20;
            this.setSize(n, 0);
            this.setLocation(0, this.host.getHeight());
        }
    }
}

