/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class ResourceDisplayPluginManager {
    private static final transient Logger log = Log.getLogger(ResourceDisplayPluginManager.class);
    private static Map map = new HashMap();
    private static Set userDefinedClasses = new HashSet();

    public static void addInstanceDisplayPluginClass(Class clazz) {
        userDefinedClasses.add(clazz);
    }

    public static ResourceDisplayPlugin getInstanceDisplayPlugin(Class clazz) {
        ResourceDisplayPlugin resourceDisplayPlugin = (ResourceDisplayPlugin)map.get(clazz);
        if (resourceDisplayPlugin == null) {
            try {
                resourceDisplayPlugin = (ResourceDisplayPlugin)clazz.newInstance();
                map.put(clazz, resourceDisplayPlugin);
            }
            catch (Exception exception) {
                System.err.println("[ResourceDisplayPluginManager] Fatal Error: Could not create Plugin for " + clazz);
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
        return resourceDisplayPlugin;
    }

    public static Class[] getInstanceDisplayPluginClasses() {
        ArrayList arrayList = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"ResourceDisplayPlugin", (String)"True"));
        arrayList.addAll(userDefinedClasses);
        Class[] classArray = arrayList.toArray(new Class[0]);
        Arrays.sort(classArray, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Class && object2 instanceof Class) {
                    return ((Class)object).getName().compareTo(((Class)object2).getName());
                }
                return 0;
            }
        });
        return classArray;
    }

    public static void initInstanceDisplay(RDFResource rDFResource, JPanel jPanel) {
        Class[] classArray = ResourceDisplayPluginManager.getInstanceDisplayPluginClasses();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Installed InstanceDisplayPlugins:");
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            ResourceDisplayPlugin resourceDisplayPlugin = ResourceDisplayPluginManager.getInstanceDisplayPlugin(clazz);
            if (log.isLoggable(Level.FINE)) {
                log.fine("- " + clazz + ": " + resourceDisplayPlugin);
            }
            if (resourceDisplayPlugin == null) continue;
            resourceDisplayPlugin.initResourceDisplay(rDFResource, jPanel);
        }
    }
}

