/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameEditor;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class InstanceNameComponent
extends JPanel
implements Disposable {
    private FrameListener frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent frameEvent) {
            InstanceNameComponent.this.updateAll();
        }
    };
    private Instance instance;
    private InstanceNameEditor textField = new InstanceNameEditor();

    public InstanceNameComponent() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.textField);
    }

    public void dispose() {
        this.removeListener();
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected String getTypeText(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = instance.getDirectTypes().iterator();
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            stringBuffer.append(cls.getBrowserText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void removeListener() {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.frameListener);
        }
    }

    public void setInstance(Instance instance) {
        this.removeListener();
        this.textField.setInstance(instance);
        this.instance = instance;
        if (instance != null) {
            instance.addFrameListener(this.frameListener);
        }
        this.updateAll();
    }

    private void updateAll() {
        if (this.instance != null) {
            this.textField.setText(this.instance.getName());
        } else {
            this.textField.setText("");
            this.setEditable(false);
        }
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    protected String getInvalidTextDescription(String string) {
        return this.textField.getInvalidTextDescription(string);
    }

    protected boolean validateText(String string) {
        return this.textField.validateText(string);
    }

    protected void commitChanges() {
        this.textField.attemptCommit();
    }

    public void setEnabled(boolean bl) {
        this.setEditable(bl);
        super.setEnabled(bl);
    }
}

