/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class AddPropertyWidgetToFormAction
extends ResourceSelectionAction {
    private RDFResource resource;
    private ResourceDisplay parent;

    public AddPropertyWidgetToFormAction(RDFResource rDFResource, ResourceDisplay resourceDisplay) {
        super("Add property widget to form...", OWLIcons.getImageIcon("AddPropertyWidgetToForm"));
        this.resource = rDFResource;
        this.parent = resourceDisplay;
    }

    public void resourceSelected(RDFResource rDFResource) {
        RDFSClass rDFSClass = this.resource.getProtegeType();
        Project project = this.resource.getProject();
        FormWidget formWidget = (FormWidget)project.getDesignTimeClsWidget((Cls)rDFSClass);
        RDFProperty rDFProperty = (RDFProperty)rDFResource;
        OWLWidgetMapper oWLWidgetMapper = (OWLWidgetMapper)project.getWidgetMapper();
        String string = oWLWidgetMapper.getDefaultWidgetClassName(rDFSClass, rDFProperty, null, true);
        formWidget.replaceWidget((Slot)rDFProperty, string);
        formWidget.setModified(true);
        formWidget.reload();
        this.parent.setInstance(null);
        this.parent.setInstance(this.resource);
    }

    public Collection getSelectableResources() {
        RDFSClass rDFSClass = this.resource.getProtegeType();
        FormWidget formWidget = (FormWidget)this.resource.getProject().getDesignTimeClsWidget((Cls)rDFSClass);
        ArrayList arrayList = new ArrayList(rDFSClass.getUnionDomainProperties(true));
        for (RDFProperty rDFProperty : rDFSClass.getUnionDomainProperties(true)) {
            if (!rDFProperty.isSystem() && rDFProperty.isVisible() && !rDFProperty.isAnnotationProperty() && formWidget.getSlotWidget((Slot)rDFProperty) == null) continue;
            arrayList.remove(rDFProperty);
        }
        return arrayList;
    }

    public RDFResource pickResource() {
        String string = "Select a property to add a widget for";
        OWLModel oWLModel = this.resource.getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)this.parent), oWLModel, this.getSelectableResources(), string);
    }
}

