/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import edu.stanford.smi.protegex.owl.repository.util.URLInputSource;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HTTPRepositoryCreatorWizardPanel
extends RepositoryCreatorWizardPanel {
    private JTextField urlField;
    private WizardPage wizardPage;
    private static final String HELP_TEXT = "<p>Please specify a URL (http address) that points to the location on the web where the ontology can be downloaded from.</p>";

    public HTTPRepositoryCreatorWizardPanel(WizardPage wizardPage) {
        this.wizardPage = wizardPage;
        this.createUI();
    }

    private void createUI() {
        this.urlField = new JTextField();
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                HTTPRepositoryCreatorWizardPanel.this.wizardPage.setPageComplete(HTTPRepositoryCreatorWizardPanel.this.validateData());
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent("URL (http:// address)", (Component)this.urlField);
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)labeledComponent, "North");
        this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, null, 160), "South");
        this.wizardPage.setPageComplete(this.validateData());
    }

    public Repository createRepository() {
        if (this.urlField.getText().length() > 0) {
            String string = null;
            try {
                URL uRL = new URL(this.urlField.getText());
                OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(new URLInputSource(uRL));
                ontologyNameExtractor.getOntologyName();
                if (ontologyNameExtractor.isPossiblyValidOntology()) {
                    return new HTTPRepository(uRL);
                }
                string = "The document pointed to by " + uRL + " does not " + "appear to be a valid ontology.";
            }
            catch (MalformedURLException malformedURLException) {
                string = "The URL " + this.urlField.getText() + " is malformed: " + malformedURLException.getMessage();
            }
            catch (IOException iOException) {
                string = "Could not obtain ontology from " + this.urlField.getText() + " due " + "to an IO error: " + iOException.getMessage();
            }
            JOptionPane.showMessageDialog(this, string, "Error", 0);
            return null;
        }
        return null;
    }

    public boolean validateData() {
        if (this.urlField.getText().length() > 0) {
            try {
                URL uRL = new URL(this.urlField.getText());
                boolean bl = uRL.getProtocol().equals("http") && uRL.getHost().length() > 0 && uRL.getPath().length() > 0;
                return bl;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }
}

