/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileBrowserPanel
extends JPanel {
    private Action browseAction;
    private JTextField fileNameField;
    private boolean showOnlyFolders;
    private WizardPage wizardPage;
    private JCheckBox forceReadOnlyCheckBox;
    private JCheckBox recursiveCheckBox;

    public FileBrowserPanel(WizardPage wizardPage, String string, boolean bl, String string2) {
        this.wizardPage = wizardPage;
        this.showOnlyFolders = bl;
        this.fileNameField = new JTextField();
        LabeledComponent labeledComponent = new LabeledComponent(string, (Component)this.fileNameField);
        this.browseAction = new AbstractAction("Browse...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                FileBrowserPanel.this.browse();
            }
        };
        wizardPage.setPageComplete(false);
        labeledComponent.addHeaderButton(this.browseAction);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        jPanel.add((Component)labeledComponent, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
        jPanel.add((Component)jPanel2, "South");
        this.forceReadOnlyCheckBox = new JCheckBox("Force Read-Only", true);
        jPanel2.add((Component)this.forceReadOnlyCheckBox, "North");
        this.recursiveCheckBox = new JCheckBox("Include sub-folders");
        if (bl) {
            jPanel2.add((Component)this.recursiveCheckBox, "South");
        }
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)jPanel, "North");
        if (string2 != null) {
            this.add((Component)OWLUI.createHelpPanel(string2, null, 160), "South");
        }
        this.fileNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                FileBrowserPanel.this.validateFileName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FileBrowserPanel.this.validateFileName();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnlyCheckBox.isSelected();
    }

    public boolean isRecursive() {
        return this.recursiveCheckBox.isSelected();
    }

    public void browse() {
        List<String> list = Arrays.asList("owl", "rdfs", "rdf");
        ExtensionFilter extensionFilter = new ExtensionFilter(list.iterator(), "Select OWL or RDF(S) files");
        JFileChooser jFileChooser = ComponentFactory.createFileChooser((String)"OWL or RDF(S) file", (ExtensionFilter)extensionFilter);
        if (this.showOnlyFolders) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(0);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.fileNameField.setText(this.getPathName(jFileChooser.getSelectedFile()));
        }
    }

    public String getPathName(File file) {
        return file.getPath();
    }

    public File getFile() {
        return new File(this.fileNameField.getText());
    }

    public boolean validateFileName() {
        File file = new File(this.fileNameField.getText());
        if (!(file.isDirectory() == this.showOnlyFolders)) {
            this.wizardPage.setPageComplete(false);
            return false;
        }
        this.wizardPage.setPageComplete(true);
        return true;
    }
}

