/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard.impl;

import edu.stanford.smi.protege.storage.database.AbstractDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.DatabaseRepository;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseWizardPanel
extends RepositoryCreatorWizardPanel {
    private static final long serialVersionUID = 8313995336416582467L;
    private static Logger log = Log.getLogger(DatabaseWizardPanel.class);
    private EnumMap<DatabaseProperty, JTextField> textMap = new EnumMap(DatabaseProperty.class);
    private JComboBox tablesBox;
    public String ANY_TABLE_ENTRY = "--All Tables--";
    private Map<String, String> descriptionToTableMap = new HashMap<String, String>();
    private WizardPage wizardPage;

    public DatabaseWizardPanel(WizardPage wizardPage, OWLModel oWLModel) {
        TextDocumentListener textDocumentListener = new TextDocumentListener();
        this.wizardPage = wizardPage;
        this.setLayout(new GridLayout(DatabaseRepository.DATABASE_FIELDS.length + 1, 1));
        for (DatabaseProperty databaseProperty : DatabaseRepository.DATABASE_FIELDS) {
            JTextField jTextField = databaseProperty == DatabaseProperty.PASSWORD_PROPERTY ? ComponentFactory.createPasswordField() : ComponentFactory.createTextField();
            jTextField.setText(DatabaseProperty.getProperty((DatabaseProperty)databaseProperty));
            this.textMap.put(databaseProperty, jTextField);
            LabeledComponent labeledComponent = new LabeledComponent(databaseProperty.getTitle(), (Component)jTextField);
            jTextField.getDocument().addDocumentListener(textDocumentListener);
            this.add((Component)labeledComponent);
        }
        this.tablesBox = new JComboBox();
        LabeledComponent labeledComponent = new LabeledComponent("Table Name", (Component)this.tablesBox);
        this.add((Component)labeledComponent);
        wizardPage.setPageComplete(this.validateFields());
        this.tablesBox.setSelectedIndex(0);
    }

    @Override
    public Repository createRepository() {
        Object object = this.tablesBox.getSelectedItem();
        if (object == null || object.equals(this.ANY_TABLE_ENTRY)) {
            return this.createAllTablesRepository();
        }
        String string = this.descriptionToTableMap.get(object);
        if (string == null) {
            return this.createAllTablesRepository();
        }
        return this.createSingleTableRepository(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseRepository createSingleTableRepository(String string) {
        Level level = AbstractDatabaseFrameDb.log.getLevel();
        AbstractDatabaseFrameDb.log.setLevel(Level.WARNING);
        try {
            DatabaseRepository databaseRepository = new DatabaseRepository(this.getText(DatabaseProperty.DRIVER_PROPERTY), this.getText(DatabaseProperty.URL_PROPERTY), this.getText(DatabaseProperty.USERNAME_PROPERTY), this.getText(DatabaseProperty.PASSWORD_PROPERTY), string);
            return databaseRepository;
        }
        catch (Throwable throwable) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("driver = " + this.getText(DatabaseProperty.DRIVER_PROPERTY));
                log.fine("url = " + this.getText(DatabaseProperty.URL_PROPERTY));
                log.fine("username = " + this.getText(DatabaseProperty.USERNAME_PROPERTY));
                log.fine("password = " + this.getText(DatabaseProperty.PASSWORD_PROPERTY));
                log.log(Level.FINE, "Create Repository failed", throwable);
            }
            DatabaseRepository databaseRepository = null;
            return databaseRepository;
        }
        finally {
            AbstractDatabaseFrameDb.log.setLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseRepository createAllTablesRepository() {
        Level level = AbstractDatabaseFrameDb.log.getLevel();
        AbstractDatabaseFrameDb.log.setLevel(Level.WARNING);
        try {
            DatabaseRepository databaseRepository = new DatabaseRepository(this.getText(DatabaseProperty.DRIVER_PROPERTY), this.getText(DatabaseProperty.URL_PROPERTY), this.getText(DatabaseProperty.USERNAME_PROPERTY), this.getText(DatabaseProperty.PASSWORD_PROPERTY));
            return databaseRepository;
        }
        catch (Throwable throwable) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("driver = " + this.getText(DatabaseProperty.DRIVER_PROPERTY));
                log.fine("url = " + this.getText(DatabaseProperty.URL_PROPERTY));
                log.fine("username = " + this.getText(DatabaseProperty.USERNAME_PROPERTY));
                log.fine("password = " + this.getText(DatabaseProperty.PASSWORD_PROPERTY));
                log.log(Level.FINE, "Create Repository failed", throwable);
            }
            DatabaseRepository databaseRepository = null;
            return databaseRepository;
        }
        finally {
            AbstractDatabaseFrameDb.log.setLevel(level);
        }
    }

    protected String getText(DatabaseProperty databaseProperty) {
        JTextField jTextField = this.textMap.get(databaseProperty);
        return jTextField.getText();
    }

    private boolean validateFields() {
        Repository repository = this.createRepository();
        this.descriptionToTableMap.clear();
        this.tablesBox.removeAllItems();
        this.tablesBox.addItem(this.ANY_TABLE_ENTRY);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (repository != null) {
            Map<String, URI> map = this.getTableToOntologyMap(repository);
            for (String string : map.keySet()) {
                URI uRI = map.get(string);
                String string2 = new StringBuffer(string).append(" (").append(uRI.toString()).append(")").toString();
                this.descriptionToTableMap.put(string2, string);
                arrayList.add(string2);
            }
            Collections.sort(arrayList);
            for (String string : arrayList) {
                this.tablesBox.addItem(string);
            }
        }
        return repository != null;
    }

    protected Map<String, URI> getTableToOntologyMap(Repository repository) {
        return ((DatabaseRepository)repository).getTableToOntologyMap();
    }

    private class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DatabaseWizardPanel.this.wizardPage.setPageComplete(DatabaseWizardPanel.this.validateFields());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DatabaseWizardPanel.this.wizardPage.setPageComplete(DatabaseWizardPanel.this.validateFields());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DatabaseWizardPanel.this.wizardPage.setPageComplete(DatabaseWizardPanel.this.validateFields());
        }
    }
}

