/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.UnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.HeadlessException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class UnresolvedImportUIHandler
implements UnresolvedImportHandler {
    public static final String ADD_OPTION = "Add Repository";
    public static final String CANCEL_OPTION = "Cancel";
    public static final ArrayList OPTIONS = new ArrayList();

    public UnresolvedImportUIHandler() {
        OPTIONS.add(ADD_OPTION);
        OPTIONS.add(CANCEL_OPTION);
    }

    public Repository handleUnresolvableImport(OWLModel oWLModel, TripleStore tripleStore, URI uRI) {
        try {
            if (!OWLUtil.runsWithGUI(oWLModel)) {
                Log.getLogger().warning("The system cannot find the ontology " + uRI + " in any of the repositories. This import will be ignored.");
                return null;
            }
            Repository repository = null;
            while (repository == null) {
                if (this.showMessage(uRI) == OPTIONS.indexOf(CANCEL_OPTION)) {
                    return null;
                }
                RepositoryWizard repositoryWizard = new RepositoryWizard(null, oWLModel);
                if (repositoryWizard.execute() == 2) {
                    return null;
                }
                repository = repositoryWizard.getRepository();
                if (repository != null) {
                    if (repository.contains(uRI)) {
                        return repository;
                    }
                    repository = null;
                }
                repositoryWizard.dispose();
            }
            return null;
        }
        catch (HeadlessException headlessException) {
            return null;
        }
    }

    private int showMessage(URI uRI) {
        return JOptionPane.showOptionDialog(null, "The system cannot find the ontology:\n" + uRI + "\n\n" + "Select '" + ADD_OPTION + "' to add a repository that contains\n" + "this ontology, or select '" + CANCEL_OPTION + "' to stop " + "loading and exit.", "Unresolved import", 2, 0, null, OPTIONS.toArray(), ADD_OPTION);
    }
}

