/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.GlobalRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.ProjectRepositoriesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class RepositoryManagerPanel
extends JPanel {
    private OWLModel model;
    private RepositoryManager repositoryManager;
    private AbstractRepositoriesPanel globalRepositoriesPanel;
    private AbstractRepositoriesPanel projectRepositoriesPanel;
    private ArrayList cachedRepositories;

    public RepositoryManagerPanel(OWLModel oWLModel) {
        this.model = oWLModel;
        this.repositoryManager = oWLModel.getRepositoryManager();
        this.cachedRepositories = new ArrayList();
        Iterator<Repository> iterator = this.repositoryManager.getAllRepositories().iterator();
        while (iterator.hasNext()) {
            this.cachedRepositories.add(iterator.next());
        }
        this.createUI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.projectRepositoriesPanel = new ProjectRepositoriesPanel(this.model, this.repositoryManager);
        jTabbedPane.add(this.projectRepositoriesPanel.getRepositoriesTitle(), this.projectRepositoriesPanel);
        this.globalRepositoriesPanel = new GlobalRepositoriesPanel(this.model, this.repositoryManager);
        jTabbedPane.add(this.globalRepositoriesPanel.getRepositoriesTitle(), this.globalRepositoriesPanel);
        this.add(jTabbedPane);
    }

    private boolean repositoriesChanged() {
        List<Repository> list = this.repositoryManager.getAllRepositories();
        if (list.size() != this.cachedRepositories.size()) {
            return true;
        }
        Iterator iterator = this.cachedRepositories.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next().equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static void showDialog(Component component, OWLModel oWLModel) {
        Object[] objectArray;
        int n;
        RepositoryManagerPanel repositoryManagerPanel = new RepositoryManagerPanel(oWLModel);
        int n2 = ProtegeUI.getModalDialogFactory().showDialog(component, repositoryManagerPanel, "Repository Manager", 14);
        if (oWLModel.getAllImports().size() > 0 && repositoryManagerPanel.repositoriesChanged() && (n = JOptionPane.showOptionDialog(repositoryManagerPanel, "<html><body>The order of repositories has changed.<br>The system needs to reload the current project. Press 'reload' to save and reload, or cancel to do a manual reload.</body></html>", "Save and reload required", 2, 2, null, objectArray = new String[]{"Reload", "Cancel"}, objectArray[0])) == 0) {
            OWLUtil.saveAndReloadProject();
        }
    }
}

