/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class RepositoryEntryLabel
extends JLabel {
    private URI name;
    private Action copyToClipboardAction;
    private Action downloadToLocalFileAction;
    private OWLModel model;

    public RepositoryEntryLabel(OWLModel oWLModel, URI uRI, String string, boolean bl) {
        this.name = uRI;
        this.model = oWLModel;
        this.setIconTextGap(20);
        String string2 = "";
        string2 = bl ? "rgb(90, 50, 180)" : "rgb(20, 20, 20)";
        String string3 = "<html><body>&nbsp;&nbsp;<font color=\"" + string2 + "\">" + uRI + "</font> <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=\"rgb(100, 100, 100)\" size=\"-2\">(" + string + ")</font></body></html>";
        this.setText(string3);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.copyToClipboardAction = new AbstractAction("Copy to clipboard"){

            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(RepositoryEntryLabel.this.name.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            }
        };
        this.downloadToLocalFileAction = new AbstractAction("Copy to local file..."){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryEntryLabel.this.copyToLocalFile();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            private void showPopupMenu(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(RepositoryEntryLabel.this.copyToClipboardAction);
                    jPopupMenu.add(RepositoryEntryLabel.this.downloadToLocalFileAction);
                    jPopupMenu.show(RepositoryEntryLabel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.showPopupMenu(mouseEvent);
            }
        });
    }

    private void copyToLocalFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showSaveDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                RepositoryUtil.createImportLocalCopy(this.model, this.name, file);
            }
            catch (OntologyLoadException ontologyLoadException) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.model, ontologyLoadException.getMessage());
            }
        }
    }
}

