/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.repository.RepositoryPanel;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractRepositoriesPanel
extends JPanel {
    private RepositoryManager manager;
    private Action addRepAction;
    private OWLModel model;
    private Box repositoriesHolder;

    public AbstractRepositoriesPanel(final OWLModel oWLModel, RepositoryManager repositoryManager) {
        this.manager = repositoryManager;
        this.model = oWLModel;
        this.addRepAction = new AbstractAction("Add repository", OWLIcons.getAddIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                RepositoryWizard repositoryWizard = new RepositoryWizard(null, oWLModel);
                int n = repositoryWizard.execute();
                if (n == 1 && repositoryWizard.getRepository() != null) {
                    AbstractRepositoriesPanel.this.addRepository(repositoryWizard.getRepository());
                }
                AbstractRepositoriesPanel.this.reloadUI();
            }
        };
        this.createUI();
    }

    protected void setAddRepositoryEnabled(boolean bl) {
        this.addRepAction.setEnabled(bl);
    }

    public abstract void addRepository(Repository var1);

    public RepositoryManager getRepositoryManager() {
        return this.manager;
    }

    public abstract List getRepositories();

    public void reloadUI() {
        List list = this.getRepositories();
        this.repositoriesHolder.removeAll();
        for (Repository repository : list) {
            this.repositoriesHolder.add(new RepositoryPanel(this.model, this.manager, repository, this));
        }
        this.revalidate();
    }

    public abstract String getRepositoriesTitle();

    private void createUI() {
        this.repositoriesHolder = new Box(1);
        this.reloadUI();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.repositoriesHolder, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getViewport().setBackground(Color.WHITE);
        LabeledComponent labeledComponent = new LabeledComponent(this.getRepositoriesTitle(), jScrollPane);
        labeledComponent.addHeaderButton(this.addRepAction);
        this.setLayout(new BorderLayout());
        this.add((Component)labeledComponent, "Center");
        this.setOpaque(false);
    }
}

