/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.refactoring;

import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class RenameAcrossFilesPanel
extends JPanel {
    private JFileChooser fileChooser;
    private SelectableList filesList = new SelectableList();
    private DefaultListModel filesListModel = new DefaultListModel();
    private JTextField newNameField;

    public RenameAcrossFilesPanel(RDFResource rDFResource, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.filesListModel.addElement(new File(string));
        }
        this.filesList.setModel((ListModel)this.filesListModel);
        this.newNameField = new JTextField(rDFResource.getName());
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Files to update references", new JScrollPane((Component)this.filesList));
        oWLLabeledComponent.addHeaderButton(new AbstractAction("Add file...", OWLIcons.getAddIcon("File")){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameAcrossFilesPanel.this.addFile();
            }
        });
        oWLLabeledComponent.addHeaderButton((Action)new AllowableAction("Remove selected file", OWLIcons.getRemoveIcon("File"), (Selectable)this.filesList){

            public void actionPerformed(ActionEvent actionEvent) {
                RenameAcrossFilesPanel.this.removeFile();
            }
        });
        this.setLayout(new BorderLayout(8, 8));
        this.add("North", (Component)new LabeledComponent("New name", (Component)this.newNameField));
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.setPreferredSize(new Dimension(400, 300));
    }

    private void addFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.filesListModel.addElement(file);
        }
    }

    public String getNewName() {
        return this.newNameField.getText();
    }

    public Iterator getSelectedFiles() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.filesList.getModel().getSize(); ++i) {
            arrayList.add(this.filesList.getModel().getElementAt(i));
        }
        return arrayList.iterator();
    }

    private void removeFile() {
        File file = (File)this.filesList.getSelectedValue();
        this.filesListModel.removeElement(file);
    }
}

