/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.query;

import com.hp.hpl.jena.query.QueryException;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.FindAssertionsAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLQueryPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SPARQLResultsPanel
extends ResultsPanel {
    private OWLModel owlModel;
    private SPARQLQueryPanel queryPanel;
    private JSplitPane splitPane;
    private JTable table;
    private Action toggleLayoutAction = new AbstractAction("Toggle layout", OWLIcons.getImageIcon("LayoutVertically")){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SPARQLResultsPanel.this.splitPane.getOrientation() == 0) {
                SPARQLResultsPanel.this.splitPane.setOrientation(1);
                SPARQLResultsPanel.this.toggleLayoutAction.putValue("SmallIcon", OWLIcons.getImageIcon("LayoutVertically"));
            } else {
                SPARQLResultsPanel.this.splitPane.setOrientation(0);
                SPARQLResultsPanel.this.toggleLayoutAction.putValue("SmallIcon", OWLIcons.getImageIcon("LayoutHorizontally"));
            }
            SPARQLResultsPanel.this.repaint();
        }
    };
    public static final String NAME = "SPARQL";

    public SPARQLResultsPanel(OWLModel oWLModel, boolean bl) {
        super(oWLModel);
        this.owlModel = oWLModel;
        this.table = new JTable(new DefaultTableModel());
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SPARQLResultsPanel.this.handleDoubleClick();
                }
            }
        });
        this.table.setCellSelectionEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.white);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Results", jScrollPane);
        if (bl) {
            this.queryPanel = new SPARQLQueryPanel(oWLModel);
            this.splitPane = new JSplitPane(1, this.queryPanel, (Component)((Object)oWLLabeledComponent));
            this.add("Center", this.splitPane);
            this.addButton(this.toggleLayoutAction);
            this.addButton(new FindAssertionsAction(oWLModel));
        } else {
            this.add("Center", (Component)((Object)oWLLabeledComponent));
        }
    }

    private TableModel createTableModel(QueryResults queryResults) {
        Object[] objectArray;
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        List list = queryResults.getVariables();
        for (int i = 0; i < list.size(); ++i) {
            objectArray = (Object[])list.get(i);
            defaultTableModel.addColumn(objectArray);
        }
        while (queryResults.hasNext()) {
            Map map = queryResults.next();
            objectArray = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                RDFObject rDFObject = (RDFObject)map.get(string);
                objectArray[i] = rDFObject;
            }
            defaultTableModel.addRow(objectArray);
        }
        return defaultTableModel;
    }

    public void dispose() {
        if (this.queryPanel != null) {
            this.queryPanel.rememberQueryText();
        }
    }

    public void executeQuery(String string) {
        try {
            this.table.setModel(new DefaultTableModel());
            this.table.revalidate();
            QueryResults queryResults = this.owlModel.executeSPARQLQuery(string);
            if (queryResults.hasNext()) {
                TableModel tableModel = this.createTableModel(queryResults);
                this.table.setModel(tableModel);
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
                    tableColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
                }
            } else {
                this.table.setModel(new DefaultTableModel());
                ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "No matches found.");
            }
        }
        catch (QueryException queryException) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Query parse error:\n" + queryException.getMessage());
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Query failed:\n" + exception.getMessage());
        }
    }

    public Icon getIcon() {
        return OWLIcons.getImageIcon("SPARQLResultsPanel");
    }

    public String getTabName() {
        return NAME;
    }

    private void handleDoubleClick() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 1) {
            Object object;
            int n = nArray[0];
            int n2 = this.table.getSelectedColumn();
            if (n2 >= 0 && n2 < this.table.getModel().getColumnCount() && (object = this.table.getModel().getValueAt(n, n2)) instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)object;
                this.showHostResource(rDFResource);
            }
        }
    }

    public void setQueryText(String string) {
        this.queryPanel.setQueryText(string);
    }
}

