/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

class UnionRangeClassesTableModel
extends AbstractTableModel
implements OWLTableModel {
    private PropertyWidget propertyWidget;
    private List rows = new ArrayList();

    UnionRangeClassesTableModel(PropertyWidget propertyWidget) {
        this.propertyWidget = propertyWidget;
    }

    public boolean addRow(RDFSClass rDFSClass, int n) {
        RDFProperty rDFProperty = this.getEditedProperty();
        OWLModel oWLModel = rDFProperty.getOWLModel();
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        if (!(rDFProperty instanceof OWLProperty) && !ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.Union_Classes)) {
            arrayList.add(rDFSClass);
        } else {
            Collection collection = rDFProperty.getUnionRangeClasses();
            for (RDFSClass rDFSClass2 : collection) {
                arrayList.add(rDFSClass2.createClone());
            }
            if (rDFProperty.getSuperpropertyCount() > 0 && !rDFProperty.isRangeDefined()) {
                this.removeSuperclasses(arrayList, rDFSClass);
            }
            if (!arrayList.contains(rDFSClass)) {
                arrayList.add(rDFSClass);
            }
        }
        try {
            rDFSClass.getOWLModel().beginTransaction("Add " + rDFSClass.getBrowserText() + " to range of " + rDFProperty.getBrowserText(), rDFProperty.getName());
            rDFProperty.setUnionRangeClasses(arrayList);
            rDFSClass.getOWLModel().commitTransaction();
        }
        catch (Exception exception) {
            rDFSClass.getOWLModel().rollbackTransaction();
            OWLUI.handleError(rDFSClass.getOWLModel(), exception);
        }
        return true;
    }

    public int addEmptyRow(int n) {
        int n2 = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    void clearRows() {
        int n = this.getRowCount();
        this.rows.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public void deleteRow(int n) {
        RDFProperty rDFProperty = this.getEditedProperty();
        RDFSClass rDFSClass = this.getClass(n);
        Collection collection = rDFProperty.getUnionRangeClasses();
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
        for (RDFSClass rDFSClass2 : collection) {
            if (rDFSClass.equals(rDFSClass2)) continue;
            arrayList.add(rDFSClass2.createClone());
        }
        try {
            rDFProperty.getOWLModel().beginTransaction("Remove " + rDFSClass.getBrowserText() + " from range of " + rDFProperty.getBrowserText(), rDFProperty.getName());
            if (arrayList.isEmpty() && rDFProperty.getSuperpropertyCount() > 0) {
                rDFProperty.setRange(null);
                rDFProperty.getOWLModel().commitTransaction();
                this.fireTableDataChanged();
            } else {
                rDFProperty.setUnionRangeClasses(arrayList);
                rDFProperty.getOWLModel().commitTransaction();
                this.fireTableRowsDeleted(n, n);
            }
        }
        catch (Exception exception) {
            rDFProperty.getOWLModel().rollbackTransaction();
            OWLUI.handleError(rDFProperty.getOWLModel(), exception);
        }
    }

    public void displaySemanticError(String string) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.propertyWidget.getOWLModel(), string);
    }

    public void dispose() {
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int n) {
        return "Expression";
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public RDFSClass getClass(int n) {
        return (RDFSClass)this.rows.get(n);
    }

    public int getClassRow(RDFSClass rDFSClass) {
        return this.rows.indexOf(rDFSClass);
    }

    public OWLNamedClass getEditedCls() {
        return null;
    }

    RDFProperty getEditedProperty() {
        return (RDFProperty)this.propertyWidget.getEditedResource();
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public RDFProperty getPredicate(int n) {
        return this.getEditedProperty().getOWLModel().getRDFSRangeProperty();
    }

    public RDFResource getRDFResource(int n) {
        return this.getClass(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public RDFResource getSubject() {
        return this.getEditedProperty();
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (this.rows.get(n) == null) {
            return "";
        }
        RDFSClass rDFSClass = this.getClass(n);
        return rDFSClass.getBrowserText();
    }

    Collection getValues() {
        RDFProperty rDFProperty = this.getEditedProperty();
        return rDFProperty.getUnionRangeClasses();
    }

    private void insertRow(RDFSClass rDFSClass) {
        int n = this.rows.size();
        this.rows.add(n, rDFSClass);
        this.fireTableRowsInserted(n, n);
    }

    public boolean isAddEnabledAt(int n) {
        return this.isEditable();
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public boolean isDeleteEnabledFor(RDFSClass rDFSClass) {
        return !this.isInherited(rDFSClass);
    }

    public boolean isEditable() {
        return this.getEditedProperty().isEditable();
    }

    boolean isInherited(RDFSClass rDFSClass) {
        RDFProperty rDFProperty = this.getEditedProperty();
        Collection collection = rDFProperty.getUnionRangeClasses();
        return rDFProperty.getRange() == null || !collection.contains(rDFSClass);
    }

    void refill() {
        this.clearRows();
        Collection collection = this.getValues();
        for (RDFSClass rDFSClass : collection) {
            this.insertRow(rDFSClass);
        }
    }

    public void removeEmptyRow() {
        int n = this.rows.indexOf(null);
        if (n >= 0) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private void removeSuperclasses(Collection collection, RDFSClass rDFSClass) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass2 = (RDFSClass)iterator.next();
            if (!rDFSClass.isSubclassOf(rDFSClass2)) continue;
            iterator.remove();
        }
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount()) {
            return;
        }
        String string = (String)object;
        if (string.trim().length() == 0) {
            this.removeEmptyRow();
            return;
        }
        try {
            OWLModel oWLModel = this.propertyWidget.getOWLModel();
            OWLClassParser oWLClassParser = oWLModel.getOWLClassParser();
            RDFSClass rDFSClass = oWLClassParser.parseClass(oWLModel, string);
            RDFSClass rDFSClass2 = this.getClass(n);
            RDFProperty rDFProperty = this.getEditedProperty();
            if (rDFSClass2 == null || !object.equals(rDFSClass2)) {
                if (rDFSClass instanceof OWLUnionClass) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Please do not assign unions as range.  The range in Protege has union\nsemantics, i.e. if you assign A or B, then this is equivalent to adding\nA and B separately in two rows.  Please convert your union into single rows.");
                    rDFSClass.delete();
                } else {
                    Collection collection = rDFProperty.getUnionRangeClasses();
                    if (collection.contains(rDFSClass)) {
                        this.displaySemanticError("The class " + rDFSClass.getBrowserText() + " is already in the union range of " + rDFProperty.getBrowserText() + ".");
                    } else {
                        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>();
                        for (RDFSClass rDFSClass3 : collection) {
                            if (rDFSClass3.equals(rDFSClass2)) {
                                arrayList.add(rDFSClass);
                                continue;
                            }
                            arrayList.add(rDFSClass3.createClone());
                        }
                        if (rDFSClass2 == null) {
                            arrayList.add(rDFSClass);
                        }
                        rDFProperty.setUnionRangeClasses(arrayList);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }
}

