/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OWLDomainTableModel
extends AbstractTableModel
implements Disposable {
    private int COL_CLASS = 0;
    private List clses = new ArrayList();
    private RDFProperty property;
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void unionDomainClassAdded(RDFProperty rDFProperty, RDFSClass rDFSClass) {
            OWLDomainTableModel.this.refill();
        }

        public void unionDomainClassRemoved(RDFProperty rDFProperty, RDFSClass rDFSClass) {
            OWLDomainTableModel.this.refill();
        }
    };

    public OWLDomainTableModel(RDFProperty rDFProperty) {
        this.property = rDFProperty;
        if (rDFProperty != null) {
            this.fill();
            rDFProperty.addPropertyListener(this.propertyListener);
        }
    }

    private boolean containsSubclassOf(Cls cls) {
        for (Cls cls2 : this.clses) {
            if (!cls2.hasSuperclass(cls)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
    }

    private void fill() {
        OWLModel oWLModel = this.property.getOWLModel();
        Slot slot = oWLModel.getSystemFrames().getDirectDomainSlot();
        List list = this.property.getDirectOwnSlotValues(slot);
        Collection collection = this.property.getSuperproperties(true);
        if (list.isEmpty() || list.size() == 1 && !collection.isEmpty() && list.contains(oWLModel.getOWLThingClass())) {
            for (Slot slot2 : collection) {
                for (Cls cls : slot2.getDirectOwnSlotValues(slot)) {
                    if (!(cls instanceof RDFSClass) || this.clses.contains(cls) || this.containsSubclassOf(cls)) continue;
                    this.clses.add(cls);
                }
            }
        } else {
            for (Cls cls : list) {
                if (!(cls instanceof RDFSClass)) continue;
                this.clses.add(cls);
            }
        }
    }

    RDFSClass getCls(int n) {
        return (RDFSClass)this.clses.get(n);
    }

    public Class getColumnClass(int n) {
        if (n == this.COL_CLASS) {
            return Frame.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return this.clses.size();
    }

    public RDFProperty getSlot() {
        return this.property;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == this.COL_CLASS) {
            return this.getCls(n);
        }
        return null;
    }

    public boolean isInherited(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            Slot slot;
            RDFProperty rDFProperty = this.getSlot();
            List list = rDFProperty.getDirectOwnSlotValues(slot = rDFProperty.getOWLModel().getSlot(":DIRECT-DOMAIN"));
            return !list.contains(cls);
        }
        return false;
    }

    private void refill() {
        this.clses.clear();
        this.fill();
        this.fireTableDataChanged();
    }

    public void setSlot(RDFProperty rDFProperty) {
        this.dispose();
        this.property = rDFProperty;
        this.clses.clear();
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
            this.fill();
        }
        this.fireTableDataChanged();
    }
}

