/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OWLDomainTable
extends SelectableTable {
    public static final int INFINITE_TIME = 1000000;

    public OWLDomainTable(final OWLDomainTableModel oWLDomainTableModel) {
        this.setModel(oWLDomainTableModel);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        ResourceRenderer resourceRenderer = new ResourceRenderer(){

            protected Icon getClsIcon(Cls cls) {
                if (oWLDomainTableModel.isInherited(cls)) {
                    ImageIcon imageIcon = ((RDFSNamedClass)cls).getImageIcon();
                    return OWLIcons.getInheritedIcon(imageIcon, "ClassFrame");
                }
                return super.getClsIcon(cls);
            }
        };
        tableColumn.setCellRenderer((TableCellRenderer)((Object)resourceRenderer));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OWLDomainTable.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)((Object)this)){

            protected JPopupMenu getPopupMenu() {
                int[] nArray = OWLDomainTable.this.getSelectedRows();
                if (nArray.length == 1) {
                    RDFSClass rDFSClass = oWLDomainTableModel.getCls(nArray[0]);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)OWLDomainTable.this), (RDFResource)rDFSClass);
                    return jPopupMenu;
                }
                return null;
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
                int n3 = n2 / OWLDomainTable.this.getRowHeight();
                if (n3 >= 0 && n3 < OWLDomainTable.this.getRowCount()) {
                    OWLDomainTable.this.getSelectionModel().setSelectionInterval(n3, n3);
                }
            }
        });
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        int n = this.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = this.getCellRect(i, 0, false);
            rectangle.setSize(this.getWidth(), rectangle.height);
            if (!rectangle.contains(mouseEvent.getPoint())) continue;
            RDFResource rDFResource = (RDFResource)this.getModel().getValueAt(i, 0);
            return OWLUI.getOWLToolTipText(rDFResource);
        }
        return null;
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.getViewport().setScrollMode(2);
            jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
    }

    public Collection getSelection() {
        OWLDomainTableModel oWLDomainTableModel = (OWLDomainTableModel)this.getModel();
        RDFProperty rDFProperty = oWLDomainTableModel.getSlot();
        if (rDFProperty != null) {
            return super.getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleDoubleClick() {
        Cls cls;
        OWLDomainTableModel oWLDomainTableModel = (OWLDomainTableModel)this.getModel();
        int n = this.getSelectedRow();
        if (n >= 0 && n < oWLDomainTableModel.getRowCount() && (cls = (Cls)oWLDomainTableModel.getValueAt(n, 0)) != null) {
            oWLDomainTableModel.getSlot().getProject().show((Instance)cls);
        }
    }
}

