/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.server.metaproject.OwlMetaProjectConstants;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertyHierarchiesPanel;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OWLPropertiesTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget {
    private ResourcePanel resourcePanel;
    private OWLPropertyHierarchiesPanel owlHierarchiesPanel;

    private JComponent createMainSplitter() {
        JSplitPane jSplitPane = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        this.owlHierarchiesPanel = new OWLPropertyHierarchiesPanel(this.getOWLModel());
        jSplitPane.setLeftComponent(this.owlHierarchiesPanel);
        this.owlHierarchiesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLPropertiesTab.this.transmitSelection();
            }
        });
        this.resourcePanel = this.createResourcePanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", (Component)((Object)this.resourcePanel));
        jSplitPane.setRightComponent(jPanel);
        return jSplitPane;
    }

    protected ResourcePanel createResourcePanel() {
        return ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 1);
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        return this.owlHierarchiesPanel.displayHostResource(rDFResource);
    }

    public Selectable getNestedSelectable() {
        return this.owlHierarchiesPanel;
    }

    public void initialize() {
        this.setIcon(OWLIcons.getPropertiesIcon());
        this.setLabel("Properties");
        this.add(this.createMainSplitter());
        if (!this.owlHierarchiesPanel.getSelection().isEmpty()) {
            this.transmitSelection();
        }
        this.setEnabled(true);
    }

    public static boolean isSuitable(Project project, Collection collection) {
        if (!(project.getKnowledgeBase() instanceof OWLModel)) {
            collection.add("This tab can only be used with OWL projects.");
            return false;
        }
        if (project.isMultiUserClient() && !RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)project.getKnowledgeBase(), (Operation)OwlMetaProjectConstants.USE_PROPERTY_TAB)) {
            collection.add("Don't have permission to access the owl properties tab");
            return false;
        }
        return true;
    }

    public void setSelectedProperty(RDFProperty rDFProperty) {
    }

    public void setSelectedSlot(OWLProperty oWLProperty) {
        this.setSelectedProperty(oWLProperty);
    }

    private void transmitSelection() {
        RDFProperty rDFProperty = (RDFProperty)CollectionUtilities.getFirstItem((Collection)this.owlHierarchiesPanel.getSelection());
        this.resourcePanel.setResource(rDFProperty);
        ((ResourceDisplay)this.resourcePanel).setEnabled(this.isEnabled());
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.getOWLModel(), (Operation)OwlMetaProjectConstants.OPERATION_PROPERTY_TAB_WRITE);
        this.owlHierarchiesPanel.setEnabled(bl);
        ((ResourceDisplay)this.resourcePanel).setEnabled(bl);
        super.setEnabled(bl);
    }
}

