/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.server.metaproject.OwlMetaProjectConstants;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.Action;
import javax.swing.JList;

public class OWLInversePropertyWidget
extends AbstractPropertyWidget {
    private ResourceSelectionAction addAction = new ResourceSelectionAction("Set inverse property...", OWLIcons.getAddIcon("OWLObjectProperty"), false){

        public void resourceSelected(RDFResource rDFResource) {
            try {
                OWLInversePropertyWidget.this.beginTransaction("Set inverse property of " + OWLInversePropertyWidget.this.getEditedResource().getBrowserText() + " to " + rDFResource.getBrowserText(), OWLInversePropertyWidget.this.getEditedResource().getName());
                OWLProperty oWLProperty = (OWLProperty)rDFResource;
                OWLInversePropertyWidget.this.setInverseProperty(oWLProperty);
                OWLInversePropertyWidget.this.commitTransaction();
            }
            catch (Exception exception) {
                OWLInversePropertyWidget.this.rollbackTransaction();
            }
        }

        public RDFResource pickResource() {
            Collection collection = OWLInversePropertyWidget.this.getPossibleInverses();
            if (collection.isEmpty()) {
                String string = "There are no existing properties which can be used as an inverse.";
                ProtegeUI.getModalDialogFactory().showMessageDialog(OWLInversePropertyWidget.this.getOWLModel(), string);
                return null;
            }
            return (OWLObjectProperty)ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)OWLInversePropertyWidget.this), OWLInversePropertyWidget.this.getOWLModel(), collection, "Select inverse property");
        }

        public Collection getSelectableResources() {
            return OWLInversePropertyWidget.this.getPossibleInverses();
        }
    };
    private AllowableAction createAction;
    private FrameListener frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            OWLInversePropertyWidget.this.updateWidget();
        }
    };
    private JList list;
    private AllowableAction removeAction;
    private AllowableAction viewAction;

    private RDFProperty createInverseProperty() {
        OWLProperty oWLProperty = null;
        try {
            OWLProperty oWLProperty2 = (OWLProperty)this.getEditedResource();
            this.beginTransaction("Create inverse property for " + oWLProperty2.getName(), oWLProperty2.getName());
            String string = oWLProperty2.getName();
            String string2 = NamespaceUtil.getNameSpace(string);
            String string3 = NamespaceUtil.getLocalName(string);
            String string4 = string2 + "inverse_of_" + string3;
            if (this.getKnowledgeBase().getFrame(string4) != null) {
                int n = 0;
                while (this.getKnowledgeBase().getFrame(string4 + "_" + n) != null) {
                    ++n;
                }
                string4 = string4 + "_" + n;
            }
            Collection collection = this.getSuperpropertyInverses(oWLProperty2);
            RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)oWLProperty2.getRDFType();
            oWLProperty = (OWLProperty)this.getKnowledgeBase().createSlot(string4, (Cls)rDFSNamedClass, collection, true);
            oWLProperty.setFunctional(false);
            this.setInverseProperty(oWLProperty);
            if (oWLProperty2.isAnnotationProperty() && !oWLProperty.isAnnotationProperty()) {
                oWLProperty.addProtegeType(oWLProperty2.getOWLModel().getOWLAnnotationPropertyClass());
            }
            this.commitTransaction();
        }
        catch (Exception exception) {
            this.rollbackTransaction();
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        return oWLProperty;
    }

    private Collection getSuperpropertyInverses(RDFProperty rDFProperty) {
        LinkedHashSet<RDFProperty> linkedHashSet = new LinkedHashSet<RDFProperty>();
        for (RDFProperty rDFProperty2 : rDFProperty.getSuperproperties(true)) {
            RDFProperty rDFProperty3 = rDFProperty2.getInverseProperty();
            if (rDFProperty3 == null) continue;
            linkedHashSet.add(rDFProperty3);
        }
        return linkedHashSet;
    }

    private JList createList() {
        SelectableList selectableList = ComponentFactory.createSingleItemList((Action)this.getViewAction());
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        return selectableList;
    }

    private Action getCreateAction() {
        if (this.createAction == null) {
            this.createAction = new CreateAction("Create new inverse property"){

                public void onCreate() {
                    RDFProperty rDFProperty = OWLInversePropertyWidget.this.createInverseProperty();
                    OWLInversePropertyWidget.this.getProject().show((Instance)rDFProperty);
                }
            };
        }
        return this.createAction;
    }

    protected Collection getPossibleInverses() {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        for (RDFProperty rDFProperty : oWLModel.getVisibleUserDefinedOWLProperties()) {
            RDFProperty rDFProperty2;
            if (!(rDFProperty instanceof OWLObjectProperty) || (rDFProperty2 = rDFProperty.getInverseProperty()) != null) continue;
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    private Action getRemoveAction() {
        if (this.removeAction == null) {
            this.removeAction = new RemoveAction("Remove inverse property", (Selectable)this){

                public void onRemove(Object object) {
                    OWLInversePropertyWidget.this.setInverseProperty(null);
                }
            };
        }
        return this.removeAction;
    }

    public Collection getSelection() {
        return this.getValues();
    }

    public Collection getValues() {
        return ComponentUtilities.getListValues((JList)this.list);
    }

    private Action getViewAction() {
        if (this.viewAction == null) {
            this.viewAction = new ViewAction("View inverse property", (Selectable)this){

                public void onView(Object object) {
                    RDFProperty rDFProperty = (RDFProperty)object;
                    OWLInversePropertyWidget.this.getProject().show((Instance)rDFProperty);
                }
            };
        }
        return this.viewAction;
    }

    public void initialize() {
        this.list = this.createList();
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), (Component)this.list);
        labeledComponent.addHeaderButton(this.getViewAction());
        labeledComponent.addHeaderButton(this.getCreateAction());
        this.addAction.activateComboBox(labeledComponent.addHeaderButton((Action)this.addAction));
        labeledComponent.addHeaderButton(this.getRemoveAction());
        this.add((Component)labeledComponent);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
        LabeledComponent labeledComponent2 = (LabeledComponent)this.getComponent(0);
        ArrayList arrayList = new ArrayList(labeledComponent2.getHeaderButtonActions());
        this.createAction.putValue("SmallIcon", (Object)OWLIcons.getCreatePropertyIcon("OWLObjectProperty"));
        this.createAction.putValue("ShortDescription", (Object)"Create new inverse property");
        Action action = (Action)arrayList.get(2);
        action.putValue("SmallIcon", OWLIcons.getAddIcon("OWLObjectProperty"));
        action.putValue("ShortDescription", "Assign existing property");
        Action action2 = (Action)arrayList.get(3);
        action2.putValue("SmallIcon", OWLIcons.getRemoveIcon("OWLObjectProperty"));
        action2.putValue("ShortDescription", "Unassign current inverse property");
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Inverse", labeledComponent2.getCenterComponent());
        oWLLabeledComponent.addHeaderButton((Action)this.createAction);
        oWLLabeledComponent.addHeaderButton(action);
        oWLLabeledComponent.addHeaderButton(action2);
        this.remove((Component)labeledComponent2);
        this.add((Component)((Object)oWLLabeledComponent));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(OWLNames.Slot.INVERSE_OF);
    }

    private void setDomain(RDFProperty rDFProperty, Collection collection) {
        for (Cls cls : collection) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            rDFProperty.addUnionDomainClass((RDFSClass)cls);
        }
    }

    public void setEditable(boolean bl) {
        this.updateWidget();
    }

    public void setInstance(Instance instance) {
        RDFResource rDFResource = this.getEditedResource();
        if (rDFResource != null && !this.isSlotAtCls()) {
            rDFResource.removeFrameListener(this.frameListener);
        }
        super.setInstance(instance);
        if (instance != null && !this.isSlotAtCls()) {
            instance.addFrameListener(this.frameListener);
        }
    }

    private void setInverseProperty(RDFProperty rDFProperty) {
        if (rDFProperty == null) {
            ComponentUtilities.setListValues((JList)this.list, (Collection)Collections.EMPTY_LIST);
        } else {
            ComponentUtilities.setListValues((JList)this.list, Collections.singleton(rDFProperty));
        }
        this.valueChanged();
        if (this.getEditedResource() instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)this.getEditedResource();
            oWLObjectProperty.setSymmetric(oWLObjectProperty.equals(rDFProperty));
        }
    }

    public void setValues(Collection collection) {
        ComponentUtilities.setListValues((JList)this.list, (Collection)collection);
    }

    private void updateWidget() {
        boolean bl;
        RDFResource rDFResource = this.getEditedResource();
        boolean bl2 = bl = !this.isSlotAtCls() && rDFResource.isEditable();
        if (bl && rDFResource instanceof Slot) {
            ValueType valueType = ((Slot)rDFResource).getValueType();
            bl = OWLInversePropertyWidget.equals((Object)valueType, (Object)ValueType.INSTANCE) || OWLInversePropertyWidget.equals((Object)valueType, (Object)ValueType.CLS);
        }
        this.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        bl = bl && RemoteClientFrameStore.isOperationAllowed((KnowledgeBase)this.getOWLModel(), (Operation)OwlMetaProjectConstants.OPERATION_PROPERTY_TAB_WRITE);
        this.createAction.setAllowed(bl);
        this.addAction.setEnabled(bl);
        this.removeAction.setAllowed(bl);
        super.setEnabled(bl);
    }

    public void dispose() {
        RDFResource rDFResource = this.getEditedResource();
        if (rDFResource != null && !this.isSlotAtCls()) {
            rDFResource.removeFrameListener(this.frameListener);
        }
        super.dispose();
    }
}

