/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ProfilesManager {
    private static Map customOntModelCache = new HashMap();
    private static OntModel defaultOntModel;
    private static Map featuresCache;
    public static final String CUSTOM_PROFILE_KEY = "OWL-CUSTOM-PROFILE-URI";
    public static final String PREDEFINED_PROFILE_URI_KEY = "OWL-PREDEFINED-PROFILE-URI";

    public static void addAltEntryForOWLProfiles(OntModel ontModel) {
        try {
            String string = new File(ProtegeOWL.getPluginFolder(), "OWLProfiles.owl").toURI().toString();
            String string2 = "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#";
            ontModel.getDocumentManager().addAltEntry(string2, string);
            string2 = string2.substring(0, string2.length() - 1);
            ontModel.getDocumentManager().addAltEntry(string2, string);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at getting profiles", exception);
        }
    }

    public static void clearCache(String string) {
        customOntModelCache.remove(string);
        featuresCache.remove(string);
    }

    public static OntModel createProfile(String string) {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ontModel.setNsPrefix("", string);
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        String string2 = string.substring(0, string.length() - 1);
        Ontology ontology = ontModel.createOntology(string2);
        ontology.addImport(ontModel.getResource("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#"));
        return ontModel;
    }

    public static OntClass getCustomProfileFeaturesClass(OntModel ontModel) {
        StmtIterator stmtIterator = ontModel.getBaseModel().listStatements(null, RDF.type, (RDFNode)OWL.Class);
        if (stmtIterator.hasNext()) {
            Resource resource = stmtIterator.nextStatement().getSubject();
            return ontModel.getOntClass(resource.getURI());
        }
        return null;
    }

    private static OntModel getCustomProfileOntModel(String string) throws Exception {
        OntModel ontModel = (OntModel)customOntModelCache.get(string);
        if (ontModel == null) {
            ontModel = ModelFactory.createOntologyModel();
            ProfilesManager.addAltEntryForOWLProfiles(ontModel);
            if (string.startsWith("http://")) {
                ontModel.read(string, "RDF/XML-ABBREV");
            } else {
                ontModel.read((InputStream)new FileInputStream(string), "http://dummy.de/ontology#", "RDF/XML-ABBREV");
            }
            customOntModelCache.put(string, ontModel);
        }
        return ontModel;
    }

    public static String getCustomProfileURI(OWLModel oWLModel) {
        return oWLModel.getOWLProject().getSettingsMap().getString(CUSTOM_PROFILE_KEY);
    }

    public static OntModel getDefaultProfileOntModel() {
        if (defaultOntModel == null) {
            defaultOntModel = ModelFactory.createOntologyModel();
            ProfilesManager.addAltEntryForOWLProfiles(defaultOntModel);
            String string = "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#";
            string = string.substring(0, string.length() - 1);
            try {
                defaultOntModel.read(string, "RDF/XML-ABBREV");
                if (defaultOntModel.getOntClass(OWLProfiles.OWL_Full.getURI()) == null) {
                    ProtegeUI.getModalDialogFactory().showErrorMessageDialog((OWLModel)null, "Could not open default OWL Profiles file.\nPlease make sure that the OWLProfiles.owl file\ncan be found in your OWL Plugin folder.");
                    defaultOntModel = null;
                    return null;
                }
            }
            catch (Exception exception) {
                Log.getLogger().warning("Could not open default Profile file. Message: " + exception.getMessage());
            }
        }
        return defaultOntModel;
    }

    public static String getDefaultProfileURI() {
        return OWLProfiles.OWL_DL.getURI();
    }

    public static Set getFeaturesSet(String string) {
        Set set = (Set)featuresCache.get(string);
        if (set == null) {
            block5: {
                try {
                    OntModel ontModel = ProfilesManager.getProfileOntModel(string);
                    OntClass ontClass = ontModel.getOntClass(string);
                    if (ontClass == null) {
                        ontClass = ProfilesManager.getCustomProfileFeaturesClass(ontModel);
                    }
                    if (ontClass == null) {
                        return null;
                    }
                    set = ProfilesManager.getSelectedClasses(ontModel, ontClass);
                }
                catch (Exception exception) {
                    if (string.equals(ProfilesManager.getDefaultProfileURI())) break block5;
                    set = ProfilesManager.getFeaturesSet(ProfilesManager.getDefaultProfileURI());
                }
            }
            featuresCache.put(string, set);
        }
        return set;
    }

    public static String getPredefinedProfile(OWLModel oWLModel) {
        String string = oWLModel.getOWLProject().getSettingsMap().getString(PREDEFINED_PROFILE_URI_KEY);
        if (string == null) {
            return ProfilesManager.getDefaultProfileURI();
        }
        return string;
    }

    public static String getProfile(OWLModel oWLModel) {
        String string = ProfilesManager.getCustomProfileURI(oWLModel);
        if (string != null) {
            return string;
        }
        return ProfilesManager.getPredefinedProfile(oWLModel);
    }

    public static OntModel getProfileOntModel(OWLModel oWLModel) throws Exception {
        String string = ProfilesManager.getProfile(oWLModel);
        return ProfilesManager.getProfileOntModel(string);
    }

    public static OntModel getProfileOntModel(String string) throws Exception {
        if (string.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            return ProfilesManager.getDefaultProfileOntModel();
        }
        return ProfilesManager.getCustomProfileOntModel(string);
    }

    public static Cls[] getSupportedRestrictionMetaClses(OWLModel oWLModel) {
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>();
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.AllValuesFrom_Restrictions)) {
            arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.SomeValuesFrom_Restrictions)) {
            arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.SOME_VALUES_FROM_RESTRICTION));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.HasValue_Restrictions)) {
            arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.HAS_VALUE_RESTRICTION));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MinCardinality_Restrictions)) {
            if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MaxCardinality_Restrictions)) {
                arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.CARDINALITY_RESTRICTION));
            }
            arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.MIN_CARDINALITY_RESTRICTION));
        }
        if (ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.MaxCardinality_Restrictions)) {
            arrayList.add(oWLModel.getRDFSNamedClass(OWLNames.Cls.MAX_CARDINALITY_RESTRICTION));
        }
        return arrayList.toArray(new Cls[0]);
    }

    public static Set getSelectedClasses(OntModel ontModel, OntClass ontClass) {
        HashSet<OntClass> hashSet = new HashSet<OntClass>();
        ProfilesManager.getSubclasses(hashSet, ontModel, ontClass, true);
        if ("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#".equals(ontClass.getNameSpace())) {
            hashSet.add(ontClass);
        } else {
            hashSet.remove(hashSet);
        }
        return hashSet;
    }

    public static Iterator getSubclasses(OntModel ontModel, OntClass ontClass) {
        HashSet hashSet = new HashSet();
        ProfilesManager.getSubclasses(hashSet, ontModel, ontClass, false);
        hashSet.remove(ontClass);
        return hashSet.iterator();
    }

    private static void getSubclasses(Set set, OntModel ontModel, OntClass ontClass, boolean bl) {
        OntClass ontClass2;
        ExtendedIterator extendedIterator = ontClass.listSubClasses(true);
        while (extendedIterator.hasNext()) {
            ontClass2 = (OntClass)extendedIterator.next();
            set.add(ontClass2);
            if (!bl) continue;
            ProfilesManager.getSubclasses(set, ontModel, ontClass2, bl);
        }
        extendedIterator = ontModel.listNamedClasses();
        block1: while (extendedIterator.hasNext()) {
            ontClass2 = (OntClass)extendedIterator.next();
            OntClass ontClass3 = ontClass2.getEquivalentClass();
            if (ontClass3 == null || !ontClass3.canAs(IntersectionClass.class)) continue;
            IntersectionClass intersectionClass = (IntersectionClass)ontClass3.as(IntersectionClass.class);
            ExtendedIterator extendedIterator2 = intersectionClass.listOperands();
            while (extendedIterator2.hasNext()) {
                OntClass ontClass4;
                Resource resource = (Resource)extendedIterator2.next();
                if (!resource.canAs(OntClass.class) || !(ontClass4 = (OntClass)resource.as(OntClass.class)).equals(ontClass) || set.contains(ontClass2)) continue;
                set.add(ontClass2);
                if (!bl) continue block1;
                ProfilesManager.getSubclasses(set, ontModel, ontClass2, bl);
                continue block1;
            }
        }
    }

    public static boolean isFeatureSupported(OWLModel oWLModel, OntClass ontClass) {
        String string = ProfilesManager.getProfile(oWLModel);
        Set set = ProfilesManager.getFeaturesSet(string);
        if (set != null) {
            return set.contains(ontClass);
        }
        return true;
    }

    public static OntModel loadOntModel(String string) {
        OntModel ontModel = ModelFactory.createOntologyModel();
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        ontModel.read(string, "RDF/XML-ABBREV");
        return ontModel;
    }

    public static void saveOntModel(OntModel ontModel, String string) throws IOException {
        String string2 = ontModel.getNsPrefixURI("");
        RDFWriter rDFWriter = ontModel.getWriter("RDF/XML-ABBREV");
        Jena.prepareWriter(rDFWriter, "RDF/XML-ABBREV", string2);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintStream printStream = new PrintStream(fileOutputStream);
        String string3 = SystemUtilities.getFileEncoding();
        Set<String> set = Charset.availableCharsets().keySet();
        if (!set.contains(string3)) {
            string3 = "UTF-8";
        }
        rDFWriter.write(ontModel.getBaseModel(), (Writer)new OutputStreamWriter((OutputStream)printStream, string3), string2);
        ((OutputStream)fileOutputStream).close();
    }

    public static void setProfile(OWLModel oWLModel, String string) {
        ProfilesManager.setProfile(oWLModel.getOWLProject(), string);
    }

    public static void setProfile(PropertyList propertyList, String string) {
        if (string.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            propertyList.setString(PREDEFINED_PROFILE_URI_KEY, string);
            propertyList.remove(CUSTOM_PROFILE_KEY);
        } else {
            propertyList.setString(CUSTOM_PROFILE_KEY, string);
        }
    }

    public static void setProfile(OWLProject oWLProject, String string) {
        SettingsMap settingsMap = oWLProject.getSettingsMap();
        if (string.startsWith("http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#")) {
            settingsMap.setString(PREDEFINED_PROFILE_URI_KEY, string);
            settingsMap.remove(CUSTOM_PROFILE_KEY);
        } else {
            settingsMap.setString(CUSTOM_PROFILE_KEY, string);
        }
    }

    static {
        featuresCache = new HashMap();
    }
}

