/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.ui.menu.OWLViewWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionPanel;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class ProfileSelectionWizardPage
extends WizardPage {
    public static boolean isBuild;
    public static final String DEFAULT_PROFILE_KEY = "ProfileSelectionWizardPage.default";
    private OWLFilesPlugin plugin;
    private Map profileRadioButtons2URI;
    private static final String HELP_TEXT = "<P>You can select which elements of OWL and RDF you want to use in your project. You can change these settings later at any time, using OWL/Preferences.</P><P>For example, if you select OWL Lite, then you cannot create owl:unionOf classes, and if you select pure RDF then you can only create rdf:Properties and rdfs:Classes.</P>";
    private Box profilesButtonsPanel;

    public ProfileSelectionWizardPage(Wizard wizard, OWLFilesPlugin oWLFilesPlugin) {
        super("View Settings", wizard);
        this.plugin = oWLFilesPlugin;
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                if (ProfileSelectionWizardPage.this.profileRadioButtons2URI == null) {
                    ProfileSelectionWizardPage.this.addProfilesButtons();
                    ProfileSelectionWizardPage.this.revalidate();
                }
            }
        });
        this.profilesButtonsPanel = Box.createVerticalBox();
        this.profilesButtonsPanel.setBorder(BorderFactory.createTitledBorder("Language Profile"));
        this.profilesButtonsPanel.add(new JLabel("Loading available profiles..."));
        this.setLayout(new BorderLayout());
        this.add("North", this.profilesButtonsPanel);
        this.add("South", OWLUI.createHelpPanel(HELP_TEXT, "Which OWL/RDF dialect do you want to use?", 160));
        this.setPageComplete(ApplicationProperties.getString((String)DEFAULT_PROFILE_KEY) != null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ProfileSelectionWizardPage.this.setPageComplete(true);
            }
        });
    }

    private void addProfilesButtons() {
        WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        waitCursor.show();
        OntModel ontModel = ProfilesManager.getDefaultProfileOntModel();
        if (ontModel != null) {
            String[] stringArray;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.profileRadioButtons2URI = new HashMap();
            this.profilesButtonsPanel.removeAll();
            String string = ApplicationProperties.getString((String)DEFAULT_PROFILE_KEY, (String)OWLProfiles.OWL_DL.getURI());
            for (String string2 : stringArray = ProfileSelectionPanel.DEFAULT_PROFILES) {
                OntClass ontClass = ontModel.getOntClass(string2);
                if (ontClass == null) continue;
                String string3 = ontClass.getLabel("");
                JRadioButton jRadioButton = new JRadioButton(string3);
                if (string2.equals(string)) {
                    jRadioButton.setSelected(true);
                }
                this.profileRadioButtons2URI.put(jRadioButton, string2);
                buttonGroup.add(jRadioButton);
                this.profilesButtonsPanel.add(jRadioButton);
            }
        }
        waitCursor.hide();
    }

    public WizardPage getNextPage() {
        return new OWLViewWizardPage(this.getWizard(), this.plugin);
    }

    public void onFinish() {
        if (this.profileRadioButtons2URI != null) {
            for (JRadioButton jRadioButton : this.profileRadioButtons2URI.keySet()) {
                if (!jRadioButton.isSelected()) continue;
                String string = (String)this.profileRadioButtons2URI.get(jRadioButton);
                this.plugin.setProfile(string);
                ApplicationProperties.setString((String)DEFAULT_PROFILE_KEY, (String)string);
            }
        }
    }
}

