/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.framework.Assert;

public class EditProfilePanel
extends JPanel {
    private static JFileChooser fileChooser;
    private JTextField fileTextField;
    private OWLModel owlModel;
    private OntModel ontModel;
    private FeatureTreeNode rootNode;
    private JTree tree;
    private static final int NODE_UNSELECTED = 0;
    private static final int NODE_SELECTED = 1;
    private static final int NODE_SOME_SELECTED = 2;

    public EditProfilePanel(OWLModel oWLModel, OntModel ontModel, String string, Collection collection) {
        this.owlModel = oWLModel;
        this.ontModel = ontModel;
        this.rootNode = this.createRootNode(collection);
        this.tree = new JTree(this.rootNode);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                EditProfilePanel.this.handleMousePressed(mouseEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Allowable Features (Note: Work in progress!)", jScrollPane);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.fileTextField = new JTextField(string);
        LabeledComponent labeledComponent = new LabeledComponent("Save profile to file:", (Component)this.fileTextField);
        AbstractAction abstractAction = new AbstractAction("Select output file", OWLIcons.getAddIcon("File")){

            public void actionPerformed(ActionEvent actionEvent) {
                EditProfilePanel.this.selectFile();
            }
        };
        labeledComponent.addHeaderButton((Action)abstractAction);
        this.add("South", (Component)labeledComponent);
    }

    private FeatureTreeNode createNode(OntClass ontClass, Collection collection) {
        FeatureTreeNode featureTreeNode = new FeatureTreeNode(ontClass, collection);
        ArrayList<FeatureTreeNode> arrayList = new ArrayList<FeatureTreeNode>();
        Iterator iterator = ProfilesManager.getSubclasses(this.ontModel, ontClass);
        while (iterator.hasNext()) {
            OntClass object = (OntClass)iterator.next();
            if (object.getLabel(null) == null) continue;
            FeatureTreeNode featureTreeNode2 = this.createNode(object, collection);
            arrayList.add(featureTreeNode2);
        }
        Collections.sort(arrayList);
        for (FeatureTreeNode featureTreeNode3 : arrayList) {
            featureTreeNode.add(featureTreeNode3);
        }
        return featureTreeNode;
    }

    private OntModel createOntModel() {
        String string = "http://www.owl-ontologies.com/MyProfile.owl#";
        OntModel ontModel = ProfilesManager.createProfile(string);
        ProfilesManager.addAltEntryForOWLProfiles(ontModel);
        ontModel.getDocumentManager().loadImport(ontModel, "http://protege.stanford.edu/plugins/owl/OWLProfiles.owl#");
        OntClass ontClass = ontModel.createClass(string + "MyProfile");
        this.rootNode.addSubclasses(ontModel, ontClass);
        return ontModel;
    }

    private FeatureTreeNode createRootNode(Collection collection) {
        OntClass ontClass = this.ontModel.getOntClass(OWLProfiles.RDF.getURI());
        Assert.assertNotNull((Object)ontClass);
        FeatureTreeNode featureTreeNode = this.createNode(ontClass, collection);
        featureTreeNode.updateSelection();
        return featureTreeNode;
    }

    private static Collection getSelectedClasses(OntModel ontModel) {
        OntClass ontClass = ProfilesManager.getCustomProfileFeaturesClass(ontModel);
        if (ontClass != null) {
            return ProfilesManager.getSelectedClasses(ontModel, ontClass);
        }
        return null;
    }

    private void handleMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle;
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0 && n < this.tree.getRowCount() && (rectangle = this.tree.getRowBounds(n)).contains(mouseEvent.getX(), mouseEvent.getY()) && mouseEvent.getX() - rectangle.x < 12) {
            TreePath treePath = this.tree.getPathForRow(n);
            FeatureTreeNode featureTreeNode = (FeatureTreeNode)treePath.getLastPathComponent();
            featureTreeNode.toggle();
            this.rootNode.updateSelection();
            this.tree.repaint();
        }
    }

    public void handleOK() {
        String string = this.fileTextField.getText();
        try {
            OntModel ontModel = this.createOntModel();
            ProfilesManager.saveOntModel(ontModel, string);
            ProfilesManager.clearCache(string);
            ProfilesManager.setProfile(this.owlModel, string);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this, "Could not write to " + string + ":\n" + exception.toString(), "Error");
        }
    }

    private void selectFile() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            this.fileTextField.setText(file.getAbsolutePath());
        }
    }

    public static boolean showProfilePanelDialog(OWLModel oWLModel) {
        try {
            OntModel ontModel = ProfilesManager.getProfileOntModel(oWLModel);
            if (ontModel != null) {
                return EditProfilePanel.showProfilePanelDialog(oWLModel, ontModel);
            }
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not find profile class:\n" + ProfilesManager.getProfile(oWLModel), "Invalid Profile");
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not open profile:\n" + exception, "Error");
        }
        return false;
    }

    public static boolean showProfilePanelDialog(OWLModel oWLModel, OntModel ontModel) {
        String string = null;
        String string2 = ProfilesManager.getCustomProfileURI(oWLModel);
        if (string2 == null) {
            string = "MyProfile.owl";
        } else if (string2.startsWith("http://")) {
            int n = string2.lastIndexOf(47);
            string = string2.substring(n + 1);
        } else {
            string = string2;
        }
        return EditProfilePanel.showProfilePanelDialog(oWLModel, ontModel, string);
    }

    public static boolean showProfilePanelDialog(OWLModel oWLModel, OntModel ontModel, String string) {
        Collection collection = EditProfilePanel.getSelectedClasses(ontModel);
        EditProfilePanel editProfilePanel = new EditProfilePanel(oWLModel, ontModel, string, collection);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), editProfilePanel, "Language Profile (" + string + ")", 11) == 1) {
            editProfilePanel.handleOK();
            return true;
        }
        return false;
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            FeatureTreeNode featureTreeNode = (FeatureTreeNode)object;
            this.setIcon(featureTreeNode.getIcon());
            return this;
        }
    }

    private class FeatureTreeNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private int selection = 0;

        FeatureTreeNode(OntClass ontClass, Collection collection) {
            this.setUserObject(ontClass);
            if (collection.contains(ontClass)) {
                this.selection = 1;
            }
        }

        public void addSubclasses(OntModel ontModel, OntClass ontClass) {
            if (this.selection == 1) {
                OntClass ontClass2 = (OntClass)this.getUserObject();
                OntClass ontClass3 = ontModel.getOntClass(ontClass2.getURI());
                ontClass3.addSuperClass((Resource)ontClass);
            } else if (this.selection == 2) {
                Enumeration<TreeNode> enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    FeatureTreeNode featureTreeNode = (FeatureTreeNode)enumeration.nextElement();
                    featureTreeNode.addSubclasses(ontModel, ontClass);
                }
            }
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }

        public Icon getIcon() {
            if (this.selection == 0) {
                return OWLIcons.getImageIcon("CheckBoxUnselected");
            }
            if (this.selection == 1) {
                return OWLIcons.getImageIcon("CheckBoxSelected");
            }
            if (this.selection == 2) {
                return OWLIcons.getImageIcon("CheckBoxSelectedGrayed");
            }
            return null;
        }

        public void toggle() {
            this.selection = this.selection == 2 || this.selection == 0 ? 1 : 0;
            this.transmitSelectionIntoChildren();
        }

        public String toString() {
            OntClass ontClass = (OntClass)this.getUserObject();
            return ontClass.getLabel(null);
        }

        public void transmitSelectionIntoChildren() {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                FeatureTreeNode featureTreeNode = (FeatureTreeNode)enumeration.nextElement();
                featureTreeNode.selection = this.selection;
                featureTreeNode.transmitSelectionIntoChildren();
            }
        }

        public void updateSelection() {
            Enumeration<TreeNode> enumeration = this.children();
            boolean bl = true;
            int n = -1;
            while (enumeration.hasMoreElements()) {
                FeatureTreeNode featureTreeNode = (FeatureTreeNode)enumeration.nextElement();
                featureTreeNode.updateSelection();
                if (n < 0) {
                    n = featureTreeNode.selection;
                    continue;
                }
                if (featureTreeNode.selection == n) continue;
                bl = false;
            }
            if (this.getChildCount() > 0) {
                this.selection = bl ? n : 2;
            }
        }
    }
}

