/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TablePopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.code.SymbolCellEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolPanel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class SymbolTable
extends SelectableTable
implements TripleSelectable {
    protected OWLTableAction editAnnotationsAction = new AbstractOWLTableAction("Edit Annotation Properties...", OWLIcons.getImageIcon("Annotation")){

        public void actionPerformed(ActionEvent actionEvent) {
            SymbolTable.this.editAnnotations();
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            if (rDFSClass instanceof OWLAnonymousClass) {
                return rDFSClass.isEditable();
            }
            return false;
        }
    };
    protected OWLTableAction editMultiLineAction = new AbstractOWLTableAction("Edit expression in multi-line editor...", Icons.getBlankIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            SymbolTable.this.editMultiLine();
        }

        public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
            if (SymbolTable.this.tableModel.isCellEditable(n, 0)) {
                return rDFSClass != null && rDFSClass.isEditable();
            }
            return false;
        }
    };
    public static final int INFINITE_TIME = 1000000;
    private OWLModel owlModel;
    private SymbolCellEditor symbolCellEditor;
    private SymbolEditorComponent symbolEditorComponent;
    private SymbolPanel symbolPanel;
    private SymbolTableModel tableModel;
    private List actions = new ArrayList();
    private boolean withIcon;

    public SymbolTable(SymbolTableModel symbolTableModel, OWLModel oWLModel, boolean bl, SymbolPanel symbolPanel) {
        this.owlModel = oWLModel;
        this.withIcon = bl;
        this.symbolPanel = symbolPanel;
        this.tableModel = symbolTableModel;
        this.setRowHeight(Math.max(this.getFontMetrics(this.getFont()).getHeight(), 16));
        this.setModel(symbolTableModel);
        this.setAutoResizeMode(3);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getSelectionModel().setSelectionMode(0);
        this.initSymbolColumn();
        this.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SymbolTable.this.enableActions();
            }
        });
        final int n = ToolTipManager.sharedInstance().getDismissDelay();
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n);
            }
        });
        this.addMouseListener((MouseListener)new TablePopupMenuMouseListener((JTable)((Object)this)){

            public JPopupMenu getPopupMenu() {
                return SymbolTable.this.createPopupMenu();
            }

            public void setSelection(JComponent jComponent, int n, int n2) {
                if (SymbolTable.this.getSelectedRowCount() > 0) {
                    super.setSelection(jComponent, n, n2);
                }
            }
        });
    }

    protected void addNavigationMenuItems(RDFResource rDFResource, JPopupMenu jPopupMenu) {
        Collection collection = this.getNavigationMenuItems(rDFResource);
        if (!collection.isEmpty()) {
            Object[] objectArray = collection.toArray(new RDFResource[0]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                jPopupMenu.add(new AbstractAction("Navigate to " + object.getBrowserText(), ProtegeUI.getIcon((RDFResource)object), (RDFResource)object){
                    final /* synthetic */ RDFResource val$targetResource;
                    {
                        this.val$targetResource = rDFResource;
                        super(string, icon);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        SymbolTable.this.navigateTo(this.val$targetResource);
                    }
                });
            }
        }
    }

    public SymbolEditorComponent getSymbolEditorComponent() {
        return this.symbolEditorComponent;
    }

    protected abstract Collection getNavigationMenuItems(RDFResource var1);

    protected void configureEnclosingScrollPane() {
        if (this.isTableHeaderHidden()) {
            Container container;
            Container container2 = this.getParent();
            if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                JViewport jViewport = jScrollPane.getViewport();
                if (jViewport == null || jViewport.getView() != this) {
                    return;
                }
                jScrollPane.getViewport().setScrollMode(2);
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        } else {
            super.configureEnclosingScrollPane();
        }
    }

    protected ResourceRenderer createOWLFrameRenderer() {
        return new ResourceRenderer();
    }

    protected JPopupMenu createPopupMenu() {
        RDFResource rDFResource = this.getSelectedOWLInstance();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (rDFResource != null) {
            this.addNavigationMenuItems(rDFResource, jPopupMenu);
        }
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            OWLTableAction oWLTableAction = (OWLTableAction)iterator.next();
            if (oWLTableAction == null) {
                if (!iterator.hasNext()) continue;
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(oWLTableAction);
        }
        if (rDFResource != null) {
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), rDFResource);
        }
        if (jPopupMenu.getComponentCount() > 0) {
            return jPopupMenu;
        }
        return null;
    }

    protected abstract SymbolEditorComponent createSymbolEditorComponent(OWLModel var1, SymbolErrorDisplay var2);

    protected void editAnnotations() {
        RDFResource rDFResource = this.getSelectedOWLInstance();
        rDFResource.getProject().show((Instance)rDFResource);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (n2 == this.tableModel.getSymbolColumnIndex()) {
            this.symbolEditorComponent.getTextComponent().requestFocus();
            if (eventObject instanceof MouseEvent) {
                int n3 = ((MouseEvent)eventObject).getX();
                if (this.withIcon) {
                    n3 -= this.symbolEditorComponent.getX();
                }
                String string = this.symbolEditorComponent.getTextComponent().getText();
                FontMetrics fontMetrics = this.symbolEditorComponent.getTextComponent().getFontMetrics(this.symbolEditorComponent.getTextComponent().getFont());
                for (int i = 1; i < string.length(); ++i) {
                    if (fontMetrics.stringWidth(string.substring(0, i)) < n3) continue;
                    this.symbolEditorComponent.getTextComponent().setCaretPosition(i - 1);
                    break;
                }
            }
        }
        return bl;
    }

    public void editExpression(int n) {
        int n2 = this.tableModel.getSymbolColumnIndex();
        this.getSelectionModel().setSelectionInterval(n, n);
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
        this.editCellAt(n, n2);
        this.symbolEditorComponent.getTextComponent().requestFocus();
    }

    protected void editMultiLine() {
        RDFResource rDFResource = this.getSelectedOWLInstance();
        String string = this.editMultiLine(rDFResource);
        if (string != null) {
            this.tableModel.setValueAt(string, this.getSelectedRow(), this.tableModel.getSymbolColumnIndex());
        }
    }

    protected abstract String editMultiLine(RDFResource var1);

    public void enableActions() {
        this.enableActions(this.actions);
    }

    protected void enableActions(Collection collection) {
    }

    public Clipboard getClipboard() {
        return this.getToolkit().getSystemClipboard();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.getRowHeight();
        return new Dimension(dimension.width, Math.max(n, dimension.height));
    }

    public ResourceRenderer getOWLFrameRenderer() {
        TableColumn tableColumn = this.getColumnModel().getColumn(this.tableModel.getSymbolColumnIndex());
        return (ResourceRenderer)((Object)tableColumn.getCellRenderer());
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JLayeredPane getParentLayeredPane() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JLayeredPane); container = container.getParent()) {
        }
        return (JLayeredPane)container;
    }

    public List getPrototypeTriples() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            RDFResource rDFResource = this.tableModel.getSubject();
            RDFProperty rDFProperty = this.tableModel.getPredicate(-1);
            if (rDFResource != null && rDFProperty != null) {
                return Collections.singletonList(new DefaultTriple(rDFResource, rDFProperty, null));
            }
            return Collections.EMPTY_LIST;
        }
        Triple triple = (Triple)this.getSelectedTriples().get(0);
        return Collections.singletonList(new DefaultTriple(triple.getSubject(), triple.getPredicate(), null));
    }

    public RDFResource getSelectedResource() {
        int n = this.getSelectedRow();
        if (n >= 0 && n < this.tableModel.getRowCount()) {
            return this.tableModel.getRDFResource(n);
        }
        return null;
    }

    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.tableModel.getRowCount()) continue;
            arrayList.add(new Integer(n));
        }
        int[] nArray2 = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            nArray2[n] = n2;
            ++n;
        }
        return nArray2;
    }

    @Deprecated
    public RDFResource getSelectedOWLInstance() {
        return this.getSelectedResource();
    }

    public List getSelectedTriples() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DefaultTriple> arrayList = new ArrayList<DefaultTriple>();
        RDFResource rDFResource = this.tableModel.getSubject();
        if (rDFResource != null) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n < 0 || n >= this.tableModel.getRowCount()) continue;
                RDFProperty rDFProperty = this.tableModel.getPredicate(n);
                RDFResource rDFResource2 = this.tableModel.getRDFResource(n);
                if (rDFProperty == null || rDFResource2 == null) continue;
                arrayList.add(new DefaultTriple(rDFResource, rDFProperty, rDFResource2));
            }
        }
        return arrayList;
    }

    protected CellEditor getSymbolCellEditor() {
        return this.symbolCellEditor;
    }

    protected SymbolPanel getSymbolPanel() {
        return this.symbolPanel;
    }

    protected SymbolTableModel getSymbolTableModel() {
        return this.tableModel;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        int n = this.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = this.getCellRect(i, 0, false);
            rectangle.setSize(this.getWidth(), rectangle.height);
            if (!rectangle.contains(mouseEvent.getPoint())) continue;
            RDFResource rDFResource = this.tableModel.getRDFResource(i);
            return this.getToolTipText(rDFResource);
        }
        return null;
    }

    protected abstract String getToolTipText(RDFResource var1);

    public void hideSymbolPanel() {
        Container container;
        if (this.symbolPanel != null && (container = this.symbolPanel.getParent()) != null) {
            container.remove(this.symbolPanel);
            Container container2 = this.getTopLevelAncestor();
            if (container2 instanceof JFrame) {
                ((JFrame)container2).getContentPane().repaint();
            } else if (container2 instanceof JWindow) {
                ((JWindow)container2).getContentPane().repaint();
            } else if (container2 instanceof JDialog) {
                ((JDialog)container2).getContentPane().repaint();
            } else {
                ProjectView projectView = ProtegeUI.getProjectView(this.getOWLModel().getProject());
                projectView.getTabbedPane().repaint();
            }
        }
    }

    protected int getPreferredRowHeight(JTable jTable, SymbolEditorComponent symbolEditorComponent) {
        return this.getRowHeight();
    }

    private void initSymbolColumn() {
        int n = this.tableModel.getSymbolColumnIndex();
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        this.symbolEditorComponent = this.createSymbolEditorComponent(this.owlModel, this.symbolPanel);
        this.symbolPanel.setSymbolEditor(this.symbolEditorComponent);
        this.symbolCellEditor = new SymbolCellEditor(this.symbolEditorComponent){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                jTable.setRowHeight(n, SymbolTable.this.getPreferredRowHeight(jTable, SymbolTable.this.symbolEditorComponent));
                if (SymbolTable.this.withIcon) {
                    JPanel jPanel = new JPanel(new BorderLayout(1, 0));
                    jPanel.setOpaque(false);
                    jPanel.add("Center", component);
                    RDFResource rDFResource = SymbolTable.this.tableModel.getRDFResource(n);
                    Icon icon = SymbolTable.this.getIcon(rDFResource);
                    jPanel.add("West", new JLabel(icon));
                    return jPanel;
                }
                return component;
            }
        };
        this.symbolEditorComponent.setSymbolEditorHandler(this.symbolCellEditor);
        this.symbolCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
                SymbolTable.this.hideSymbolPanel();
            }

            public void editingStopped(ChangeEvent changeEvent) {
                SymbolTable.this.hideSymbolPanel();
            }
        });
        this.initSymbolColumnRenderer();
    }

    protected Icon getIcon(RDFResource rDFResource) {
        Icon icon = null;
        icon = rDFResource == null ? this.getDefaultCellEditorIcon(rDFResource) : this.tableModel.getIcon(rDFResource);
        return icon;
    }

    protected Icon getDefaultCellEditorIcon(RDFResource rDFResource) {
        return OWLIcons.getPrimitiveClsIcon();
    }

    private void initSymbolColumnRenderer() {
        if (this.tableModel != null) {
            int n = this.tableModel.getSymbolColumnIndex();
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            if (this.withIcon) {
                ResourceRenderer resourceRenderer = this.createOWLFrameRenderer();
                resourceRenderer.setDisplayHiddenIcon(false);
                tableColumn.setCellRenderer((TableCellRenderer)((Object)resourceRenderer));
            }
            tableColumn.setCellEditor(this.symbolCellEditor);
        }
    }

    protected boolean isTableHeaderHidden() {
        return this.getModel().getColumnCount() == 1;
    }

    protected void navigateTo(RDFResource rDFResource) {
        ResultsPanelManager.showHostResource(rDFResource);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (n2 == this.tableModel.getSymbolColumnIndex()) {
            Object object = this.getModel().getValueAt(n, n2);
            String string = object instanceof RDFResource ? ((RDFResource)object).getBrowserText() : (String)object;
            this.showSymbolPanel(string.length() == 0);
        }
        return component;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (n2 == this.tableModel.getSymbolColumnIndex() && tableCellRenderer instanceof FrameRenderer) {
            RDFResource rDFResource = this.tableModel.getRDFResource(n);
            boolean bl = this.isCellSelected(n, n2);
            boolean bl2 = this.selectionModel.getAnchorSelectionIndex() == n;
            boolean bl3 = this.columnModel.getSelectionModel().getAnchorSelectionIndex() == n2;
            boolean bl4 = bl2 && bl3 && this.isFocusOwner();
            return tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), rDFResource, bl, bl4, n, n2);
        }
        return super.prepareRenderer(tableCellRenderer, n, n2);
    }

    public void registerAction(OWLTableAction oWLTableAction) {
        this.actions.add(oWLTableAction);
        oWLTableAction.setEnabled(false);
    }

    public void registerAction(OWLTableAction oWLTableAction, int n) {
        this.actions.add(n, oWLTableAction);
        oWLTableAction.setEnabled(false);
    }

    public void registerActionSeparator() {
        this.actions.add(null);
    }

    public void setModel(TableModel tableModel) {
        TableModel tableModel2 = this.getModel();
        if (tableModel2 instanceof Disposable) {
            ((Disposable)tableModel2).dispose();
        }
        super.setModel(tableModel);
        if (tableModel instanceof SymbolTableModel) {
            this.tableModel = (SymbolTableModel)tableModel;
        }
        this.initSymbolColumnRenderer();
    }

    public void setSelectedRow(RDFResource rDFResource) {
        String string = rDFResource.getBrowserText();
        this.setSelectedRow(string);
    }

    public void setSelectedRow(String string) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            RDFResource rDFResource = this.tableModel.getRDFResource(i);
            if (rDFResource == null || !string.equals(rDFResource.getBrowserText())) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    public void setSelectedRow(int n) {
        if (n < 0 || n >= this.tableModel.getRowCount()) {
            this.getSelectionModel().clearSelection();
        } else {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void setSelectedTriples(Collection collection) {
        this.getSelectionModel().clearSelection();
        block0: for (Triple triple : collection) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                if (!triple.getObject().equals(this.tableModel.getRDFResource(i))) continue;
                this.getSelectionModel().addSelectionInterval(i, i);
                continue block0;
            }
        }
    }

    protected void showSymbolPanel(boolean bl) {
        int n;
        JLayeredPane jLayeredPane = this.getParentLayeredPane();
        int n2 = this.tableModel.getSymbolColumnIndex();
        Rectangle rectangle = this.getCellRect(this.getSelectedRow(), n2, true);
        Point point = this.getLocationOnScreen();
        Point point2 = jLayeredPane.getLocationOnScreen();
        rectangle.translate(point.x - point2.x, point.y - point2.y);
        Dimension dimension = this.symbolPanel.getPreferredSize();
        int n3 = this.getX() + rectangle.x;
        if (dimension.width > rectangle.width) {
            n3 = Math.max(0, this.getX() + rectangle.x - (dimension.width - rectangle.width));
        }
        if ((n = rectangle.y + rectangle.height + 4) + this.symbolPanel.getHeight() >= jLayeredPane.getHeight()) {
            n = rectangle.y - this.symbolPanel.getHeight();
        }
        this.symbolPanel.setLocation(n3, n);
        this.symbolPanel.displayError((Throwable)null);
        this.symbolPanel.setErrorFlag(bl);
        this.symbolPanel.enableActions(true, true);
        jLayeredPane.setLayer(this.symbolPanel, JLayeredPane.POPUP_LAYER);
        jLayeredPane.add(this.symbolPanel);
    }
}

