/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractOWLTableModel
extends AbstractTableModel
implements OWLTableModel {
    private OWLNamedClass cls;
    private int expressionColumn;
    private List rows = new ArrayList();
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            AbstractOWLTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            AbstractOWLTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            AbstractOWLTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            AbstractOWLTableModel.this.refill();
        }
    };

    protected AbstractOWLTableModel(int n) {
        this.expressionColumn = n;
    }

    public int addEmptyRow(int n) {
        int n2 = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    protected void addRows() {
        Collection collection = this.cls.getSuperclasses(true);
        for (Cls cls : collection) {
            if (!this.isSuitable(cls)) continue;
            this.insertRow(cls);
        }
    }

    void clearRows() {
        int n = this.getRowCount();
        this.rows.clear();
        if (n > 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
    }

    public void deleteRow(int n) {
        RDFSClass rDFSClass = (RDFSClass)this.rows.get(n);
        OWLModel oWLModel = this.cls.getOWLModel();
        if (this.cls.getNamedSuperclasses().size() == 1 && rDFSClass instanceof OWLNamedClass) {
            this.cls.addSuperclass(oWLModel.getOWLThingClass());
        }
        this.cls.removeSuperclass(rDFSClass);
        this.fireTableRowsDeleted(n, n);
    }

    public void displaySemanticError(String string) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.cls.getOWLModel(), string, "Semantic Error");
    }

    public void dispose() {
        if (this.cls != null) {
            this.removeListeners();
        }
    }

    Cls getCls() {
        return this.cls;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int n) {
        return "Expression";
    }

    public RDFSClass getClass(int n) {
        return (RDFSClass)this.rows.get(n);
    }

    public int getClassRow(RDFSClass rDFSClass) {
        return this.rows.indexOf(rDFSClass);
    }

    public OWLNamedClass getEditedCls() {
        return this.cls;
    }

    public RDFResource getRDFResource(int n) {
        return this.getClass(n);
    }

    public RDFResource getSubject() {
        return this.cls;
    }

    public int getSymbolColumnIndex() {
        return this.expressionColumn;
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public boolean isAddEnabledAt(int n) {
        return this.isEditable();
    }

    public boolean isEditable() {
        return this.getEditedCls().isEditable();
    }

    protected abstract int getInsertRowIndex(Cls var1);

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        if (this.rows.get(n) == null) {
            return "";
        }
        RDFSClass rDFSClass = this.getClass(n);
        return rDFSClass.getBrowserText();
    }

    protected void insertRow(Cls cls) {
        if (this.isSuitable(cls)) {
            int n = this.getInsertRowIndex(cls);
            this.rows.add(n, cls);
            this.fireTableRowsInserted(n, n);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == this.expressionColumn;
    }

    protected abstract boolean isSuitable(Cls var1);

    public void refill() {
        this.clearRows();
        this.addRows();
    }

    public void removeEmptyRow() {
        int n = this.rows.indexOf(null);
        if (n >= 0) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private void removeListeners() {
        this.cls.removeClassListener(this.classListener);
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        this.clearRows();
        if (this.cls != null) {
            this.removeListeners();
        }
        this.cls = oWLNamedClass;
        if (this.cls != null) {
            this.cls.addClassListener(this.classListener);
            this.addRows();
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount()) {
            return;
        }
        if (n2 == this.expressionColumn) {
            String string = (String)object;
            try {
                this.setValueAt(n, this.cls.getOWLModel(), string);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
    }

    protected abstract void setValueAt(int var1, OWLModel var2, String var3) throws Exception;
}

