/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.navigation;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.navigation.ProgrammaticSelectionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;

public class TabNavigationHistorySelectable
implements Disposable,
NavigationHistorySelectable,
SelectionListener {
    private Collection listeners = new HashSet();
    private boolean programmaticNavigation = false;
    private Project project;
    private Collection tabs = new ArrayList();
    private ContainerListener containerListener = new ContainerListener(){

        public void componentAdded(ContainerEvent containerEvent) {
            TabNavigationHistorySelectable.this.reinit();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            TabNavigationHistorySelectable.this.reinit();
        }
    };

    public TabNavigationHistorySelectable(OWLModel oWLModel) {
        this.project = oWLModel.getProject();
        ProjectView projectView = ProtegeUI.getProjectView(this.project);
        projectView.getTabbedPane().addContainerListener(this.containerListener);
        this.reinit();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listeners.add(selectionListener);
    }

    public void clearSelection() {
    }

    public void dispose() {
        ProjectView projectView = ProtegeUI.getProjectView(this.project);
        projectView.getTabbedPane().removeContainerListener(this.containerListener);
        this.removeListener();
    }

    public Collection getSelection() {
        ProjectView projectView = ProtegeUI.getProjectView(this.project);
        TabWidget tabWidget = projectView.getSelectedTab();
        if (tabWidget instanceof NavigationHistoryTabWidget) {
            NavigationHistoryTabWidget navigationHistoryTabWidget = (NavigationHistoryTabWidget)tabWidget;
            Selectable selectable = navigationHistoryTabWidget.getNestedSelectable();
            return selectable.getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigateToResource(RDFResource rDFResource) {
        ProjectView projectView = ProtegeUI.getProjectView(this.project);
        ArrayList<TabWidget> arrayList = new ArrayList<TabWidget>();
        arrayList.add(projectView.getSelectedTab());
        arrayList.addAll(this.tabs);
        try {
            this.programmaticNavigation = true;
            for (Object e : arrayList) {
                if (!(e instanceof NavigationHistoryTabWidget) || !((NavigationHistoryTabWidget)e).displayHostResource(rDFResource)) continue;
                projectView.setSelectedTab((TabWidget)e);
                ((JComponent)e).requestFocusInWindow();
                return;
            }
        }
        finally {
            this.programmaticNavigation = false;
        }
    }

    public void notifySelectionListeners() {
        for (SelectionListener selectionListener : this.listeners) {
            ProgrammaticSelectionEvent programmaticSelectionEvent = this.programmaticNavigation ? new ProgrammaticSelectionEvent(this) : new SelectionEvent((Selectable)this, 1);
            selectionListener.selectionChanged((SelectionEvent)programmaticSelectionEvent);
        }
    }

    public void reinit() {
        this.removeListener();
        ProjectView projectView = ProtegeUI.getProjectView(this.project);
        for (Object e : projectView.getTabs()) {
            if (!(e instanceof NavigationHistoryTabWidget)) continue;
            NavigationHistoryTabWidget navigationHistoryTabWidget = (NavigationHistoryTabWidget)e;
            this.tabs.add(e);
            Selectable selectable = navigationHistoryTabWidget.getNestedSelectable();
            selectable.addSelectionListener((SelectionListener)this);
        }
    }

    private void removeListener() {
        for (NavigationHistoryTabWidget navigationHistoryTabWidget : this.tabs) {
            Selectable selectable = navigationHistoryTabWidget.getNestedSelectable();
            selectable.removeSelectionListener((SelectionListener)this);
        }
        this.tabs.clear();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        this.notifySelectionListeners();
    }
}

