/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.navigation;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.navigation.ProgrammaticSelectionEvent;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public class NavigationHistoryManager
extends DefaultListModel
implements ComboBoxModel,
Disposable {
    private ResourceSelectionAction backAction = new ResourceSelectionAction("Back", OWLIcons.getNavigateBackIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            NavigationHistoryManager.this.back();
        }

        public void resourceSelected(RDFResource rDFResource) {
            while (!rDFResource.equals(NavigationHistoryManager.this.getResource(NavigationHistoryManager.this.index))) {
                NavigationHistoryManager.this.index--;
            }
            NavigationHistoryManager.this.setSelectedResourceByCurrentIndex();
            NavigationHistoryManager.this.updateActionStatus();
        }

        public Collection getSelectableResources() {
            HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
            for (int i = NavigationHistoryManager.this.index - 1; i >= 0; --i) {
                hashSet.add(NavigationHistoryManager.this.getResource(i));
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            return arrayList;
        }

        public RDFResource pickResource() {
            return null;
        }
    };
    private ModelListener deleteListener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            if (NavigationHistoryManager.this.resourcesSet.contains(rDFSClass)) {
                NavigationHistoryManager.this.removeResource(rDFSClass);
            }
        }

        public void individualDeleted(RDFResource rDFResource) {
            if (NavigationHistoryManager.this.resourcesSet.contains(rDFResource)) {
                NavigationHistoryManager.this.removeResource(rDFResource);
            }
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            if (NavigationHistoryManager.this.resourcesSet.contains(rDFProperty)) {
                NavigationHistoryManager.this.removeResource(rDFProperty);
            }
        }
    };
    private ResourceSelectionAction forwardAction = new ResourceSelectionAction("Forward", OWLIcons.getNavigateForwardIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            NavigationHistoryManager.this.forward();
        }

        public void resourceSelected(RDFResource rDFResource) {
            while (!rDFResource.equals(NavigationHistoryManager.this.getResource(NavigationHistoryManager.this.index))) {
                NavigationHistoryManager.this.index++;
            }
            NavigationHistoryManager.this.setSelectedResourceByCurrentIndex();
            NavigationHistoryManager.this.updateActionStatus();
        }

        public Collection getSelectableResources() {
            HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
            for (int i = NavigationHistoryManager.this.index; i < NavigationHistoryManager.this.getSize(); ++i) {
                hashSet.add(NavigationHistoryManager.this.getResource(i));
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            return arrayList;
        }

        public RDFResource pickResource() {
            return null;
        }
    };
    private int index = -1;
    private Set listeners = new HashSet();
    private NavigationHistorySelectable navigationHistorySelectable;
    private OWLModel owlModel;
    private Set resourcesSet = new HashSet();
    private SelectionListener selectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent selectionEvent) {
            if (!(selectionEvent instanceof ProgrammaticSelectionEvent)) {
                NavigationHistoryManager.this.handleSelectionChanged();
            }
        }
    };

    public NavigationHistoryManager(NavigationHistorySelectable navigationHistorySelectable, OWLModel oWLModel) {
        this.navigationHistorySelectable = navigationHistorySelectable;
        this.owlModel = oWLModel;
        this.owlModel.addModelListener(this.deleteListener);
        this.updateActionStatus();
        this.navigationHistorySelectable.addSelectionListener(this.selectionListener);
    }

    public void add(RDFResource rDFResource) {
        ++this.index;
        this.add(this.index, rDFResource);
        while (this.getSize() > this.index + 1) {
            this.removeResourceByIndex(this.index + 1);
        }
        if (!this.resourcesSet.contains(rDFResource)) {
            this.resourcesSet.add(rDFResource);
        }
        this.updateActionStatus();
    }

    public void addIndexListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void back() {
        if (this.index > 0) {
            --this.index;
            this.setSelectedResourceByCurrentIndex();
            this.updateActionStatus();
        }
    }

    public void dispose() {
        this.navigationHistorySelectable.removeSelectionListener(this.selectionListener);
        this.navigationHistorySelectable.dispose();
        this.owlModel.removeModelListener(this.deleteListener);
    }

    public void forward() {
        if (this.index < this.getSize() - 1) {
            ++this.index;
            this.setSelectedResourceByCurrentIndex();
            this.updateActionStatus();
        }
    }

    public ResourceSelectionAction getBackAction() {
        return this.backAction;
    }

    public RDFResource getResource(int n) {
        return (RDFResource)this.getElementAt(n);
    }

    public ResourceSelectionAction getForwardAction() {
        return this.forwardAction;
    }

    public int getSelectedIndex() {
        return this.index;
    }

    private void handleSelectionChanged() {
        Object e;
        Collection collection = this.navigationHistorySelectable.getSelection();
        if (collection.size() == 1 && (e = collection.iterator().next()) instanceof RDFResource) {
            RDFResource rDFResource = (RDFResource)e;
            this.add(rDFResource);
            this.updateActionStatus();
        }
    }

    private void removeResource(RDFResource rDFResource) {
        RDFResource rDFResource2;
        int n;
        this.resourcesSet.remove(rDFResource);
        for (n = this.getSize() - 1; n > this.index; --n) {
            rDFResource2 = this.getResource(n);
            if (!rDFResource2.equals(rDFResource)) continue;
            this.remove(n);
        }
        for (n = this.index; n >= 0; --n) {
            rDFResource2 = this.getResource(n);
            if (!rDFResource2.equals(rDFResource)) continue;
            this.remove(n);
            --this.index;
        }
    }

    private void removeResourceByIndex(int n) {
        RDFResource rDFResource = this.getResource(n);
        this.remove(n);
        this.resourcesSet.remove(rDFResource);
        if (this.contains(rDFResource)) {
            this.resourcesSet.add(rDFResource);
        }
    }

    private void setSelectedResourceByCurrentIndex() {
        RDFResource rDFResource = this.getResource(this.index);
        this.navigationHistorySelectable.navigateToResource(rDFResource);
    }

    private void updateActionStatus() {
        this.backAction.setEnabled(this.index > 0);
        this.forwardAction.setEnabled(this.index < this.getSize() - 1);
        for (ActionListener actionListener : new ArrayList(this.listeners)) {
            actionListener.actionPerformed(null);
        }
    }

    public Object getSelectedItem() {
        if (this.index >= 0 && this.index < this.getSize()) {
            return this.getResource(this.index);
        }
        return null;
    }

    public void setSelectedItem(Object object) {
        if (!object.equals(this.getResource(this.index))) {
            this.index = 0;
            for (int i = this.getSize() - 1; i >= 0; --i) {
                RDFResource rDFResource = this.getResource(i);
                if (!rDFResource.equals(object)) continue;
                this.index = i;
                this.setSelectedResourceByCurrentIndex();
                break;
            }
            this.updateActionStatus();
        }
    }
}

